/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.monster;

import com.greymerk.roguelike.dungeon.Difficulty;
import com.greymerk.roguelike.monster.IEntity;
import com.greymerk.roguelike.monster.IMonsterProfile;
import com.greymerk.roguelike.monster.profiles.ProfileArcher;
import com.greymerk.roguelike.monster.profiles.ProfileAshlea;
import com.greymerk.roguelike.monster.profiles.ProfileBaby;
import com.greymerk.roguelike.monster.profiles.ProfileEvoker;
import com.greymerk.roguelike.monster.profiles.ProfileHusk;
import com.greymerk.roguelike.monster.profiles.ProfileJohnny;
import com.greymerk.roguelike.monster.profiles.ProfileMagicArcher;
import com.greymerk.roguelike.monster.profiles.ProfilePigman;
import com.greymerk.roguelike.monster.profiles.ProfilePoisonArcher;
import com.greymerk.roguelike.monster.profiles.ProfileRleahy;
import com.greymerk.roguelike.monster.profiles.ProfileSkeleton;
import com.greymerk.roguelike.monster.profiles.ProfileSwordsman;
import com.greymerk.roguelike.monster.profiles.ProfileTallMob;
import com.greymerk.roguelike.monster.profiles.ProfileVillager;
import com.greymerk.roguelike.monster.profiles.ProfileVindicator;
import com.greymerk.roguelike.monster.profiles.ProfileWitch;
import com.greymerk.roguelike.monster.profiles.ProfileWither;
import com.greymerk.roguelike.monster.profiles.ProfileZombie;
import net.minecraft.class_1613;
import net.minecraft.class_1642;
import net.minecraft.class_1937;
import net.minecraft.class_5819;

public enum MonsterProfile {
    TALLMOB,
    ZOMBIE,
    PIGMAN,
    SKELETON,
    VILLAGER,
    HUSK,
    BABY,
    ASHLEA,
    RLEAHY,
    ARCHER,
    WITHER,
    POISONARCHER,
    MAGICARCHER,
    SWORDSMAN,
    EVOKER,
    VINDICATOR,
    WITCH,
    JOHNNY;


    public static IMonsterProfile get(MonsterProfile profile) {
        switch (profile.ordinal()) {
            case 0: {
                return new ProfileTallMob();
            }
            case 1: {
                return new ProfileZombie();
            }
            case 2: {
                return new ProfilePigman();
            }
            case 3: {
                return new ProfileSkeleton();
            }
            case 4: {
                return new ProfileVillager();
            }
            case 5: {
                return new ProfileHusk();
            }
            case 6: {
                return new ProfileBaby();
            }
            case 7: {
                return new ProfileAshlea();
            }
            case 8: {
                return new ProfileRleahy();
            }
            case 9: {
                return new ProfileArcher();
            }
            case 10: {
                return new ProfileWither();
            }
            case 11: {
                return new ProfilePoisonArcher();
            }
            case 12: {
                return new ProfileMagicArcher();
            }
            case 13: {
                return new ProfileSwordsman();
            }
            case 14: {
                return new ProfileEvoker();
            }
            case 15: {
                return new ProfileVindicator();
            }
            case 16: {
                return new ProfileWitch();
            }
            case 17: {
                return new ProfileJohnny();
            }
        }
        return new ProfileTallMob();
    }

    public static void equip(class_1937 world, class_5819 rand, Difficulty diff, IEntity mob) {
        IMonsterProfile profile = null;
        if (mob.instance(class_1642.class)) {
            profile = MonsterProfile.get(ZOMBIE);
        }
        if (mob.instance(class_1613.class)) {
            profile = MonsterProfile.get(SKELETON);
        }
        if (profile == null) {
            return;
        }
        profile.addEquipment(world, rand, diff, mob);
    }
}

