/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.mixin;

import com.greymerk.roguelike.config.Config;
import com.greymerk.roguelike.dungeon.Dungeon;
import com.greymerk.roguelike.dungeon.DungeonPlacement;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.WorldEditor;
import com.greymerk.roguelike.gamerules.RoguelikeRules;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_3218;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2794.class})
public class ChunkFeatureMixin {
    @Inject(at={@At(value="HEAD")}, method={"generateFeatures"})
    public void generateFeatures(class_5281 worldAccess, class_2791 chunk, class_5138 structureAccessor, CallbackInfo info) {
        class_3218 sw = worldAccess.method_8410();
        WorldEditor editor = new WorldEditor(worldAccess, (class_5321<class_1937>)sw.method_27983());
        if (!editor.getGameRules().method_8355(RoguelikeRules.GEN_ROGUELIKE_DUNGEONS)) {
            return;
        }
        class_1923 cpos = chunk.method_12004();
        Coord pos = new Coord(cpos.method_33940(), 200, cpos.method_33942());
        if (!DungeonPlacement.validChunkPos(editor, cpos)) {
            return;
        }
        if (!Dungeon.canSpawn(editor, pos.copy())) {
            return;
        }
        class_5819 rand = editor.getRandom(pos);
        Double chance = Math.max(0.0, Math.min(1.0, Config.ofDouble(Config.FREQUENCY)));
        Double roll = rand.method_43058();
        if (chance == 1.0 || roll < chance) {
            Dungeon.generate(editor, pos);
        }
    }
}

