/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.shapes;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.shapes.IShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_5819;

public class RectWireframe
implements IShape {
    private BoundingBox bb;

    public RectWireframe(BoundingBox bb) {
        this.bb = bb;
    }

    public static void fill(IWorldEditor editor, class_5819 rand, Coord start, Coord end, IBlockFactory block) {
        RectWireframe.fill(editor, rand, start, end, block, true, true);
    }

    public static void fill(IWorldEditor editor, class_5819 rand, Coord start, Coord end, IBlockFactory block, boolean fillAir, boolean replaceSolid) {
        RectWireframe rect = new RectWireframe(BoundingBox.of(start, end));
        rect.fill(editor, rand, block, fillAir, replaceSolid);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block) {
        this.fill(editor, rand, block, true, true);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block, boolean fillAir, boolean replaceSolid) {
        for (Coord c : this) {
            block.set(editor, rand, c, fillAir, replaceSolid);
        }
    }

    @Override
    public List<Coord> get() {
        ArrayList<Coord> coords = new ArrayList<Coord>();
        for (Coord c : this) {
            coords.add(c);
        }
        return coords;
    }

    @Override
    public Iterator<Coord> iterator() {
        return new RectWireframeIterator(this.bb);
    }

    private class RectWireframeIterator
    implements Iterator<Coord> {
        Coord cursor;
        Coord c1;
        Coord c2;

        public RectWireframeIterator(BoundingBox bb) {
            this.c1 = bb.getStart();
            this.c2 = bb.getEnd();
            this.cursor = this.c1.copy();
        }

        @Override
        public boolean hasNext() {
            return this.cursor.getY() <= this.c2.getY();
        }

        @Override
        public Coord next() {
            Coord toReturn = this.cursor.copy();
            if (this.cursor.getZ() == this.c2.getZ() && this.cursor.getX() == this.c2.getX()) {
                this.cursor = new Coord(this.c1.getX(), this.cursor.getY(), this.c1.getZ());
                this.cursor.add(Cardinal.UP);
                return toReturn;
            }
            if (this.cursor.getY() == this.c1.getY() || this.cursor.getY() == this.c2.getY()) {
                if (this.cursor.getX() == this.c2.getX()) {
                    this.cursor = new Coord(this.c1.getX(), this.cursor.getY(), this.cursor.getZ());
                    this.cursor.add(Cardinal.SOUTH);
                    return toReturn;
                }
                if (this.cursor.getZ() == this.c1.getZ() || this.cursor.getZ() == this.c2.getZ()) {
                    this.cursor.add(Cardinal.EAST);
                    return toReturn;
                }
                if (this.cursor.getX() == this.c1.getX()) {
                    this.cursor = new Coord(this.c2.getX(), this.cursor.getY(), this.cursor.getZ());
                    return toReturn;
                }
            }
            if (this.cursor.getX() == this.c1.getX()) {
                this.cursor = new Coord(this.c2.getX(), this.cursor.getY(), this.cursor.getZ());
                return toReturn;
            }
            if (this.cursor.getX() == this.c2.getX()) {
                this.cursor = new Coord(this.c1.getX(), this.cursor.getY(), this.c2.getZ());
                return toReturn;
            }
            this.cursor = new Coord(this.c2.getX(), this.cursor.getY(), this.cursor.getZ());
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

