/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.shapes;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.boundingbox.IBounded;
import com.greymerk.roguelike.editor.shapes.IShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_5819;

public class RectSolid
implements IShape {
    private BoundingBox bb;

    public RectSolid(BoundingBox bb) {
        this.bb = bb;
    }

    public static void fill(IWorldEditor editor, class_5819 rand, IBounded box, IBlockFactory blocks) {
        new RectSolid(box.getBoundingBox()).fill(editor, rand, blocks, true, true);
    }

    public static void fill(IWorldEditor editor, class_5819 rand, IBounded box, IBlockFactory blocks, boolean fillAir, boolean replaceSolid) {
        new RectSolid(box.getBoundingBox()).fill(editor, rand, blocks, fillAir, replaceSolid);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block) {
        this.fill(editor, rand, block, true, true);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block, boolean fillAir, boolean replaceSolid) {
        this.forEach(c -> block.set(editor, rand, (Coord)c, fillAir, replaceSolid));
    }

    @Override
    public List<Coord> get() {
        ArrayList<Coord> coords = new ArrayList<Coord>();
        this.forEach(c -> coords.add((Coord)c));
        return coords;
    }

    @Override
    public Iterator<Coord> iterator() {
        return new RectSolidIterator(this.bb);
    }

    private class RectSolidIterator
    implements Iterator<Coord> {
        Coord cursor;
        Coord c1;
        Coord c2;

        public RectSolidIterator(BoundingBox bb) {
            this.c1 = bb.getStart();
            this.c2 = bb.getEnd();
            this.cursor = this.c1.copy();
        }

        @Override
        public boolean hasNext() {
            return this.cursor.getY() <= this.c2.getY();
        }

        @Override
        public Coord next() {
            Coord toReturn = this.cursor.copy();
            if (this.cursor.getZ() == this.c2.getZ() && this.cursor.getX() == this.c2.getX()) {
                this.cursor = new Coord(this.c1.getX(), this.cursor.getY(), this.c1.getZ());
                this.cursor.add(Cardinal.UP);
                return toReturn;
            }
            if (this.cursor.getX() == this.c2.getX()) {
                this.cursor = new Coord(this.c1.getX(), this.cursor.getY(), this.cursor.getZ());
                this.cursor.add(Cardinal.SOUTH);
                return toReturn;
            }
            this.cursor.add(Cardinal.EAST);
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

