/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.shapes;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.boundingbox.IBounded;
import com.greymerk.roguelike.editor.shapes.IShape;
import com.greymerk.roguelike.editor.shapes.RectSolid;
import com.greymerk.roguelike.editor.shapes.Shape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_5819;

public class RectHollow
implements IShape {
    private BoundingBox bb;

    public RectHollow(BoundingBox bb) {
        this.bb = bb;
    }

    public static void fill(IWorldEditor editor, class_5819 rand, IBounded bb, IBlockFactory block, boolean fillAir, boolean replaceSolid) {
        bb.getShape(Shape.RECTHOLLOW).fill(editor, rand, block, fillAir, replaceSolid);
    }

    public static void fill(IWorldEditor editor, class_5819 rand, IBounded bb, IBlockFactory block) {
        bb.getShape(Shape.RECTHOLLOW).fill(editor, rand, block, true, true);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block) {
        this.fill(editor, rand, block, true, true);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block, boolean fillAir, boolean replaceSolid) {
        for (Coord c : this) {
            block.set(editor, rand, c, fillAir, replaceSolid);
        }
        BoundingBox inner = this.bb.copy().grow(Cardinal.all, -1);
        RectSolid.fill(editor, rand, inner, new MetaBlock(class_2246.field_10543));
    }

    @Override
    public List<Coord> get() {
        ArrayList<Coord> coords = new ArrayList<Coord>();
        for (Coord c : this) {
            coords.add(c);
        }
        return coords;
    }

    @Override
    public Iterator<Coord> iterator() {
        return new RectHollowIterator(this.bb);
    }

    private class RectHollowIterator
    implements Iterator<Coord> {
        Coord cursor;
        Coord c1;
        Coord c2;

        public RectHollowIterator(BoundingBox bb) {
            this.c1 = bb.getStart();
            this.c2 = bb.getEnd();
            this.cursor = this.c1.copy();
        }

        @Override
        public boolean hasNext() {
            return this.cursor.getY() <= this.c2.getY();
        }

        @Override
        public Coord next() {
            Coord toReturn = this.cursor.copy();
            if (this.cursor.getZ() == this.c2.getZ() && this.cursor.getX() == this.c2.getX()) {
                this.cursor = new Coord(this.c1.getX(), this.cursor.getY(), this.c1.getZ());
                this.cursor.add(Cardinal.UP);
                return toReturn;
            }
            if (this.cursor.getX() == this.c2.getX()) {
                this.cursor = new Coord(this.c1.getX(), this.cursor.getY(), this.cursor.getZ());
                this.cursor.add(Cardinal.SOUTH);
                return toReturn;
            }
            if (this.cursor.getY() != this.c1.getY() && this.cursor.getY() != this.c2.getY() && this.cursor.getZ() != this.c1.getZ() && this.cursor.getZ() != this.c2.getZ() && this.cursor.getX() == this.c1.getX()) {
                this.cursor.add(Cardinal.EAST, this.c2.getX() - this.c1.getX());
            } else {
                this.cursor.add(Cardinal.EAST);
            }
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

