/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.shapes;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.shapes.IShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_5819;

public class Ellipsoid
implements IShape {
    private Coord start;
    private Coord end;

    public Ellipsoid(Coord start, Coord end) {
        this.start = start.copy();
        this.end = end.copy();
    }

    @Override
    public Iterator<Coord> iterator() {
        return new EllipsoidIterator(this.start, this.end);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block) {
        this.fill(editor, rand, block, true, true);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block, boolean fillAir, boolean replaceSolid) {
        for (Coord pos : this) {
            block.set(editor, rand, pos, fillAir, replaceSolid);
        }
    }

    @Override
    public List<Coord> get() {
        ArrayList<Coord> copy = new ArrayList<Coord>();
        for (Coord pos : this) {
            copy.add(pos);
        }
        return copy;
    }

    private class EllipsoidIterator
    implements Iterator<Coord> {
        private Coord centre;
        private Coord diff;
        private Coord cursor;
        private Cardinal dir;
        private boolean top;

        public EllipsoidIterator(Coord centre, Coord end) {
            this.centre = centre.copy();
            Coord s = centre.copy();
            Coord e = end.copy();
            this.diff = e.sub(s);
            this.diff = new Coord(Math.abs(this.diff.getX()), Math.abs(this.diff.getY()), Math.abs(this.diff.getZ()));
            this.cursor = new Coord(0, 0, 0);
            this.top = true;
            this.dir = Cardinal.NORTH;
        }

        @Override
        public boolean hasNext() {
            return this.cursor.getY() < this.diff.getY();
        }

        @Override
        public Coord next() {
            Coord toReturn = this.centre.copy();
            toReturn.add(this.top ? Cardinal.UP : Cardinal.DOWN, this.cursor.getY());
            if (this.dir == Cardinal.NORTH || this.dir == Cardinal.SOUTH) {
                toReturn.add(Cardinal.left(this.dir), this.cursor.getX());
                toReturn.add(this.dir, this.cursor.getZ());
            } else {
                toReturn.add(this.dir, this.cursor.getX());
                toReturn.add(Cardinal.left(this.dir), this.cursor.getZ());
            }
            if (this.dir != Cardinal.NORTH || this.top) {
                if (this.dir == Cardinal.NORTH) {
                    this.top = false;
                }
                this.dir = Cardinal.left(this.dir);
                return toReturn;
            }
            this.cursor.add(Cardinal.SOUTH);
            if (this.inRange(this.cursor)) {
                this.dir = Cardinal.left(this.dir);
                this.top = true;
                return toReturn;
            }
            this.cursor = new Coord(this.cursor.getX(), this.cursor.getY(), 0);
            this.cursor.add(Cardinal.EAST);
            if (this.inRange(this.cursor)) {
                this.dir = Cardinal.left(this.dir);
                this.top = true;
                return toReturn;
            }
            this.cursor = new Coord(0, this.cursor.getY(), this.cursor.getZ());
            this.cursor.add(Cardinal.UP);
            this.dir = Cardinal.left(this.dir);
            this.top = true;
            return toReturn;
        }

        private boolean inRange(Coord pos) {
            double x = pos.getX();
            double y = pos.getY();
            double z = pos.getZ();
            double rx = this.diff.getX() == 0 ? 1.0 : (double)this.diff.getX();
            double ry = this.diff.getY() == 0 ? 1.0 : (double)this.diff.getY();
            double rz = this.diff.getZ() == 0 ? 1.0 : (double)this.diff.getZ();
            return x / rx * (x / rx) + y / ry * (y / ry) + z / rz * (z / rz) <= 1.0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

