/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.shapes;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.shapes.IShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_5819;

public class Column
implements IShape {
    Coord top;

    public Column(Coord top) {
        this.top = top.copy();
    }

    public static void fillDown(IWorldEditor editor, class_5819 rand, IBlockFactory blocks, Coord top) {
        new Column(top).fillDown(editor, rand, blocks);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block) {
        this.forEach(c -> block.set(editor, rand, this.top, true, true));
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block, boolean fillAir, boolean replaceSolid) {
        this.forEach(c -> block.set(editor, rand, this.top, fillAir, replaceSolid));
    }

    public List<Coord> getUntilSolid(IWorldEditor editor) {
        FillDownIterator itr = new FillDownIterator(editor, this.top.copy());
        ArrayList<Coord> cl = new ArrayList<Coord>();
        itr.forEachRemaining(c -> cl.add((Coord)c));
        return cl;
    }

    @Override
    public List<Coord> get() {
        ArrayList<Coord> cl = new ArrayList<Coord>();
        this.forEach(c -> cl.add((Coord)c));
        return cl;
    }

    public void fillDown(IWorldEditor editor, class_5819 rand, IBlockFactory blocks) {
        this.fillDown(editor, rand, blocks, true, true);
    }

    public void fillDown(IWorldEditor editor, class_5819 rand, IBlockFactory blocks, boolean fillAir, boolean replaceSolid) {
        FillDownIterator itr = new FillDownIterator(editor, this.top.copy());
        itr.forEachRemaining(c -> blocks.set(editor, rand, (Coord)c, fillAir, replaceSolid));
    }

    @Override
    public Iterator<Coord> iterator() {
        return new ColumnIterator(this.top.copy());
    }

    private class FillDownIterator
    extends ColumnIterator {
        private IWorldEditor editor;

        public FillDownIterator(IWorldEditor editor, Coord origin) {
            super(origin);
            this.editor = editor;
        }

        @Override
        public boolean hasNext() {
            if (this.editor.isSolid(this.current)) {
                return false;
            }
            return this.current.getY() > -62;
        }
    }

    private class ColumnIterator
    implements Iterator<Coord> {
        static final int MAX_DEPTH = -62;
        Coord current;

        public ColumnIterator(Coord origin) {
            this.current = origin.copy();
        }

        @Override
        public boolean hasNext() {
            return this.current.getY() > -62;
        }

        @Override
        public Coord next() {
            Coord last = this.current.copy();
            this.current.add(Cardinal.DOWN);
            return last;
        }
    }
}

