/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.factories;

import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.BlockType;
import com.greymerk.roguelike.editor.factories.BlockBase;
import com.greymerk.roguelike.editor.factories.BlockWeightedRandom;
import net.minecraft.class_5819;

public class BlockFloor
extends BlockBase
implements IBlockFactory {
    private IBlockFactory floor;
    private IBlockFactory bridge;

    public BlockFloor(IBlockFactory floor) {
        this.floor = floor;
        BlockWeightedRandom bridge = new BlockWeightedRandom();
        bridge.addBlock(floor, 10);
        bridge.addBlock(BlockType.get(BlockType.AIR), 1);
        this.bridge = bridge;
    }

    @Override
    public boolean set(IWorldEditor editor, class_5819 rand, Coord pos, boolean fillAir, boolean replaceSolid) {
        if (!fillAir && editor.isAir(pos)) {
            return false;
        }
        if (!replaceSolid && editor.isSolid(pos)) {
            return false;
        }
        this.floor.set(editor, rand, pos, false, true);
        this.bridge.set(editor, rand, pos, true, false);
        return true;
    }
}

