/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.blocks.door;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.blocks.door.DoorType;
import com.greymerk.roguelike.editor.blocks.door.IDoor;
import net.minecraft.class_2323;
import net.minecraft.class_2680;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2769;

public class Door
implements IDoor {
    MetaBlock block;

    public static Door of(DoorType type) {
        return new Door(type);
    }

    public Door(MetaBlock block) {
        this.block = block;
    }

    public Door(DoorType type) {
        this.block = DoorType.get(type);
    }

    @Override
    public void generate(IWorldEditor editor, Coord pos, Cardinal dir) {
        Door.generate(editor, this.block, pos, dir, false);
    }

    @Override
    public void generate(IWorldEditor editor, Coord pos, Cardinal dir, boolean open) {
        Door.generate(editor, this.block, pos, dir, open);
    }

    public static void generate(IWorldEditor editor, Coord pos, Cardinal dir, DoorType type) {
        MetaBlock door = DoorType.get(type);
        Door.generate(editor, door, pos, dir, false);
    }

    public static void generate(IWorldEditor editor, MetaBlock door, Coord pos, Cardinal dir, boolean open) {
        Coord cursor = pos.copy();
        MetaBlock doorBase = Door.setProperties(door, false, dir, open, false);
        doorBase.set(editor, cursor);
        cursor.add(Cardinal.UP);
        MetaBlock doorTop = Door.setProperties(door, true, dir, open, false);
        doorTop.set(editor, cursor);
    }

    private static MetaBlock setProperties(MetaBlock doorblock, boolean top, Cardinal dir, boolean open, boolean hingeLeft) {
        class_2680 door = doorblock.getBlock().method_9564();
        door = (class_2680)door.method_11657((class_2769)class_2323.field_10946, (Comparable)(top ? class_2756.field_12609 : class_2756.field_12607));
        door = (class_2680)door.method_11657((class_2769)class_2323.field_10938, (Comparable)Cardinal.facing(dir));
        door = (class_2680)door.method_11657((class_2769)class_2323.field_10945, (Comparable)Boolean.valueOf(open));
        door = (class_2680)door.method_11657((class_2769)class_2323.field_10941, (Comparable)(hingeLeft ? class_2750.field_12588 : class_2750.field_12586));
        return new MetaBlock(door);
    }
}

