/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.state.RoguelikeState;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5218;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6862;
import net.minecraft.class_7134;
import net.minecraft.class_7699;
import net.minecraft.server.MinecraftServer;

public class WorldEditor
implements IWorldEditor {
    class_5321<class_1937> worldKey;
    class_1936 world;

    public WorldEditor(class_3218 world) {
        this.world = world;
        this.worldKey = world.method_27983();
    }

    public WorldEditor(class_5281 world, class_5321<class_1937> key) {
        this.world = world;
        this.worldKey = key;
    }

    @Override
    public boolean set(Coord pos, MetaBlock block, boolean fillAir, boolean replaceSolid) {
        if (this.hasBlockEntity(pos)) {
            return false;
        }
        if (!fillAir && this.isAir(pos)) {
            return false;
        }
        if (!replaceSolid && this.isSolid(pos)) {
            return false;
        }
        try {
            this.world.method_8652(pos.getBlockPos(), block.getState(), block.getFlag());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean set(Coord pos, MetaBlock metaBlock) {
        return this.set(pos, metaBlock, true, true);
    }

    @Override
    public MetaBlock getBlock(Coord pos) {
        class_2680 state = this.world.method_8320(pos.getBlockPos());
        return new MetaBlock(state);
    }

    @Override
    public boolean isAir(Coord pos) {
        return this.world.method_22347(pos.getBlockPos());
    }

    @Override
    public long getSeed() {
        MinecraftServer server = this.world.method_8503();
        class_3218 sw = server.method_30002();
        return sw.method_8412();
    }

    @Override
    public long getSeed(Coord pos) {
        return Objects.hash(this.getSeed(), pos.hashCode());
    }

    @Override
    public class_5819 getRandom(Coord pos) {
        return new class_5820(this.getSeed(pos));
    }

    @Override
    public boolean isChunkLoaded(Coord pos) {
        class_1923 cp = pos.getChunkPos();
        class_2791 c = this.world.method_22350(pos.getBlockPos());
        class_2806 status = c.method_12009();
        if (status != class_2806.field_12803) {
            return false;
        }
        return this.world.method_8393(cp.field_9181, cp.field_9180);
    }

    @Override
    public boolean surroundingChunksLoaded(Coord pos) {
        class_1923 cpos = pos.getChunkPos();
        for (int x = cpos.field_9181 - 1; x <= cpos.field_9181 + 1; ++x) {
            for (int z = cpos.field_9180 - 1; z <= cpos.field_9180 + 1; ++z) {
                if (this.isChunkLoaded(Coord.of(new class_1923(x, z)))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Coord findSurface(Coord pos) {
        Coord cursor = new Coord(pos.getX(), this.world.method_31600(), pos.getZ());
        while (cursor.getY() > 60) {
            MetaBlock m = this.getBlock(cursor);
            if (m.getState().method_26164(class_3481.field_15475) || m.getState().method_26164(class_3481.field_15503)) continue;
            if (!this.isAir(cursor) && !this.isPlant(cursor)) {
                return cursor;
            }
            cursor.add(Cardinal.DOWN);
        }
        return cursor;
    }

    @Override
    public boolean isSolid(Coord pos) {
        return this.world.method_8320(pos.getBlockPos()).method_26212((class_1922)this.world, pos.getBlockPos());
    }

    @Override
    public boolean isSupported(Coord pos) {
        if (pos.getY() <= this.world.method_31607()) {
            return false;
        }
        Coord under = pos.copy().add(Cardinal.DOWN);
        class_2248 b = this.world.method_8320(under.getBlockPos()).method_26204();
        if (b instanceof class_2346) {
            return this.isSupported(under);
        }
        return !class_2346.method_10128((class_2680)this.world.method_8320(under.getBlockPos()));
    }

    public boolean isPlant(Coord pos) {
        class_2680 bs = this.getBlock(pos).getState();
        if (bs.method_26164(class_3481.field_15475)) {
            return true;
        }
        return bs.method_26164(class_3481.field_44469);
    }

    @Override
    public boolean isGround(Coord pos) {
        if (this.isPlant(pos)) {
            return false;
        }
        if (this.isAir(pos)) {
            return false;
        }
        ArrayList<class_6862> tags = new ArrayList<class_6862>();
        tags.add(class_3481.field_25806);
        tags.add(class_3481.field_29822);
        tags.add(class_3481.field_15466);
        tags.add(class_3481.field_29823);
        tags.add(class_3481.field_28992);
        tags.add(class_3481.field_36265);
        tags.add(class_3481.field_33716);
        MetaBlock m = this.getBlock(pos);
        for (class_6862 tag : tags) {
            if (!m.getState().method_26164(tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOverworld() {
        MinecraftServer mcServer = this.world.method_8503();
        class_3218 sw = mcServer.method_3847(this.worldKey);
        return sw.method_44013().equals(class_7134.field_37666);
    }

    @Override
    public boolean hasBlockEntity(Coord pos) {
        return this.getBlockEntity(pos) != null;
    }

    @Override
    public class_2586 getBlockEntity(Coord pos) {
        return this.world.method_8321(pos.getBlockPos());
    }

    @Override
    public boolean isFaceFullSquare(Coord pos, Cardinal dir) {
        class_2680 b = this.world.method_8320(pos.getBlockPos());
        class_2350 facing = Cardinal.facing(dir);
        class_265 shape = b.method_26222((class_1922)this.world, pos.getBlockPos());
        class_265 collision = b.method_26220((class_1922)this.world, pos.getBlockPos());
        boolean isShapeSquare = class_2248.method_9501((class_265)shape, (class_2350)facing);
        boolean isCollisionSquare = class_2248.method_9501((class_265)collision, (class_2350)facing);
        return isShapeSquare || isCollisionSquare;
    }

    @Override
    public int getMaxDepth() {
        return this.world.method_31607();
    }

    @Override
    public class_5455 getRegistryManager() {
        class_5455 reg = this.world.method_30349();
        return reg;
    }

    @Override
    public class_7699 getFeatureSet() {
        return this.world.method_45162();
    }

    @Override
    public Path getWorldDirectory() {
        return this.world.method_8503().method_27050(class_5218.field_24188);
    }

    @Override
    public class_1928 getGameRules() {
        MinecraftServer server = this.world.method_8503();
        class_1928 rules = server.method_3767();
        return rules;
    }

    @Override
    public RoguelikeState getState() {
        MinecraftServer server = this.world.method_8503();
        return RoguelikeState.getServerState(this.worldKey, server);
    }

    @Override
    public class_5321<class_1937> getKey() {
        return this.worldKey;
    }
}

