/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.layout.Entrance;
import com.greymerk.roguelike.dungeon.room.AbyssRoom;
import com.greymerk.roguelike.dungeon.room.BedRoom;
import com.greymerk.roguelike.dungeon.room.BrewingRoom;
import com.greymerk.roguelike.dungeon.room.CisternRoom;
import com.greymerk.roguelike.dungeon.room.Corridor;
import com.greymerk.roguelike.dungeon.room.CreeperRoom;
import com.greymerk.roguelike.dungeon.room.CrossRoom;
import com.greymerk.roguelike.dungeon.room.CryptRoom;
import com.greymerk.roguelike.dungeon.room.EnderRoom;
import com.greymerk.roguelike.dungeon.room.EntranceRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.KitchenRoom;
import com.greymerk.roguelike.dungeon.room.MusicRoom;
import com.greymerk.roguelike.dungeon.room.OssuaryRoom;
import com.greymerk.roguelike.dungeon.room.PanopticonRoom;
import com.greymerk.roguelike.dungeon.room.PrisonRoom;
import com.greymerk.roguelike.dungeon.room.ReservoirRoom;
import com.greymerk.roguelike.dungeon.room.Stairway;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.boundingbox.IBounded;
import com.greymerk.roguelike.settings.ILevelSettings;
import com.greymerk.roguelike.settings.LevelSettings;
import java.util.Arrays;
import net.minecraft.class_2487;

public enum Room {
    CORRIDOR,
    ENTRANCE,
    STAIRWAY,
    CROSS,
    BEDROOM,
    CRYPT,
    RESERVOIR,
    CISTERN,
    OSSUARY,
    KITCHEN,
    CREEPER,
    ENDER,
    ABYSS,
    PRISON,
    MUSIC,
    BREWING,
    PANOPTICON;


    public static IRoom fromType(Room type) {
        switch (type.ordinal()) {
            case 0: {
                return new Corridor();
            }
            case 1: {
                return new EntranceRoom();
            }
            case 2: {
                return new Stairway();
            }
            case 3: {
                return new CrossRoom();
            }
            case 4: {
                return new BedRoom();
            }
            case 5: {
                return new CryptRoom();
            }
            case 6: {
                return new ReservoirRoom();
            }
            case 7: {
                return new CisternRoom();
            }
            case 8: {
                return new OssuaryRoom();
            }
            case 9: {
                return new KitchenRoom();
            }
            case 10: {
                return new CreeperRoom();
            }
            case 11: {
                return new EnderRoom();
            }
            case 12: {
                return new AbyssRoom();
            }
            case 13: {
                return new PrisonRoom();
            }
            case 14: {
                return new MusicRoom();
            }
            case 15: {
                return new BrewingRoom();
            }
            case 16: {
                return new PanopticonRoom();
            }
        }
        return new Corridor();
    }

    public static IRoom createFromNBT(class_2487 tag) {
        Room type = Room.get(tag.method_10580("type").method_10714());
        IRoom room = Room.fromType(type);
        room.setLevelSettings(LevelSettings.get(tag.method_10558("settings")));
        room.setWorldPos(Coord.of(tag.method_10562("pos")));
        int dirValue = tag.method_10550("dir");
        room.setDirection(Arrays.asList(Cardinal.values()).get(dirValue));
        room.setGenerated(tag.method_10577("generated"));
        class_2487 entrances = tag.method_10562("entrances");
        for (Cardinal dir : Cardinal.directions) {
            if (!entrances.method_10545(dir.name())) continue;
            String entName = entrances.method_10558(dir.name());
            Entrance entType = Entrance.valueOf(entName);
            room.addEntrance(dir, entType);
        }
        return room;
    }

    public static Room get(String name) {
        for (Room type : Room.values()) {
            if (!type.toString().equals(name)) continue;
            return type;
        }
        return CORRIDOR;
    }

    public static boolean contains(String name) {
        for (Room type : Room.values()) {
            if (!type.toString().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static IRoom getInstance(Room type, ILevelSettings settings) {
        IRoom room = Room.fromType(type);
        room.setLevelSettings(settings);
        return room;
    }

    public static IRoom getInstance(Room type, ILevelSettings settings, Coord floorPos, Coord worldPos) {
        IRoom room = Room.fromType(type);
        room.setLevelSettings(settings);
        room.setFloorPos(floorPos);
        room.setWorldPos(worldPos);
        return room;
    }

    public static IRoom getInstance(Room type, ILevelSettings settings, Coord floorPos, Coord worldPos, Cardinal dir) {
        IRoom room = Room.getInstance(type, settings, floorPos, worldPos);
        room.setDirection(dir);
        return room;
    }

    public static IRoom getInstance(Room type, ILevelSettings settings, IBounded box, Coord pos, Cardinal dir) {
        IRoom room = Room.fromType(type);
        room.setLevelSettings(settings);
        room.setWorldPos(pos);
        room.setDirection(dir);
        return room;
    }
}

