/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.fragment.Fragment;
import com.greymerk.roguelike.dungeon.layout.Entrance;
import com.greymerk.roguelike.dungeon.room.AbstractMediumRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.IronBar;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.factories.BlockWeightedRandom;
import com.greymerk.roguelike.editor.shapes.RectSolid;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_5819;

public class PrisonRoom
extends AbstractMediumRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        Coord origin = this.worldPos.copy().add(this.direction, 6);
        class_5819 rand = editor.getRandom(origin);
        this.ceiling(editor, rand, origin);
        this.clear(editor, rand, origin);
        this.outerWall(editor, rand, origin);
        this.center(editor, rand, origin);
        this.floor(editor, rand, origin);
        this.doors(editor, rand, origin);
        this.cells(editor, rand, origin);
    }

    private void ceiling(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.UP, 4).grow(Cardinal.UP).grow(Cardinal.directions, 9);
        RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
    }

    private void cells(IWorldEditor editor, class_5819 rand, Coord origin) {
        for (Cardinal dir : Cardinal.directions) {
            Coord pos;
            if (this.getEntrance(dir) != Entrance.DOOR) {
                pos = origin.copy().add(dir, 6);
                this.mainCell(editor, rand, pos, dir);
                if (this.getEntrance(Cardinal.left(dir)) != Entrance.DOOR) {
                    pos.add(Cardinal.left(dir), 6);
                    ArrayList<Cardinal> doors = new ArrayList<Cardinal>();
                    doors.add(Cardinal.reverse(dir));
                    doors.add(Cardinal.right(dir));
                    this.closedCell(editor, rand, pos, doors);
                    continue;
                }
                pos.add(Cardinal.left(dir), 6);
                this.sideCell(editor, rand, pos, dir);
                continue;
            }
            if (this.getEntrance(Cardinal.left(dir)) != Entrance.DOOR) {
                pos = origin.copy();
                pos.add(dir, 6).add(Cardinal.left(dir), 6);
                this.sideCell(editor, rand, pos, Cardinal.left(dir));
                continue;
            }
            pos = origin.copy();
            pos.add(dir, 6).add(Cardinal.left(dir), 6);
            this.cornerCell(editor, rand, pos, Cardinal.left(dir));
        }
    }

    private void cornerCell(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal cellDir) {
        IStair stair = this.theme.getPrimary().getStair();
        for (Cardinal dir : Cardinal.directions) {
            BoundingBox bb = BoundingBox.of(origin.copy());
            bb.add(dir, 2).add(Cardinal.left(dir), 2);
            bb.grow(Cardinal.UP, 3);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getPillar());
            bb = BoundingBox.of(origin.copy());
            bb.add(dir, 2).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir));
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
            if (dir == Cardinal.reverse(cellDir) || dir == Cardinal.left(cellDir)) {
                bb = BoundingBox.of(origin.copy());
                bb.add(dir, 2).grow(Cardinal.orthogonal(dir)).grow(Cardinal.UP, 2);
                BlockWeightedRandom bars = new BlockWeightedRandom();
                bars.addBlock(IronBar.get(), 3);
                bars.addBlock(Air.get(), 1);
                RectSolid.fill(editor, rand, bb, bars);
                continue;
            }
            for (Cardinal o : Cardinal.orthogonal(dir)) {
                Coord pos = origin.copy();
                pos.add(dir, 2).add(o).add(Cardinal.UP, 2);
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, pos);
            }
            this.settings.getWallFragment(rand).generate(editor, rand, this.theme, origin, dir);
        }
        Coord pos = origin.copy();
        pos.add(Cardinal.reverse(cellDir), 2).add(Cardinal.left(cellDir), 2).add(Cardinal.UP, 3);
        for (Cardinal dir : Cardinal.directions) {
            stair.setOrientation(dir, true).set(editor, rand, pos.copy().add(dir), true, false);
        }
        Fragment.generate(Fragment.CELL_SUPPORT, editor, rand, this.theme, origin.copy());
    }

    private void sideCell(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal cellDir) {
        BlockWeightedRandom bars = new BlockWeightedRandom();
        bars.addBlock(IronBar.get(), 2);
        bars.addBlock(Air.get(), 1);
        for (Cardinal dir : Cardinal.directions) {
            BoundingBox bb = BoundingBox.of(origin.copy());
            bb.add(dir, 2).add(Cardinal.left(dir), 2).grow(Cardinal.UP, 3);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getPillar());
            bb = BoundingBox.of(origin.copy());
            bb.add(dir, 2).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir));
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
        }
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.reverse(cellDir), 2).grow(Cardinal.UP, 2).grow(Cardinal.orthogonal(cellDir));
        RectSolid.fill(editor, rand, bb, bars);
        this.settings.getWallFragment(rand).generate(editor, rand, this.theme, origin, cellDir);
        Fragment.generate(Fragment.CELL_SUPPORT, editor, rand, this.theme, origin.copy());
    }

    private void closedCell(IWorldEditor editor, class_5819 rand, Coord origin, List<Cardinal> doors) {
        IStair stair = this.theme.getPrimary().getStair();
        for (Cardinal dir : Cardinal.directions) {
            BoundingBox bb = BoundingBox.of(origin.copy());
            bb.add(dir, 2).add(Cardinal.left(dir), 2).grow(Cardinal.UP, 3);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getPillar());
            bb = BoundingBox.of(origin.copy());
            bb.add(dir, 2).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir));
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
        }
        for (Cardinal dir : Cardinal.directions) {
            if (doors.contains((Object)dir)) continue;
            for (Cardinal o : Cardinal.orthogonal(dir)) {
                Coord pos = origin.copy();
                pos.add(dir, 2).add(o).add(Cardinal.UP, 2);
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, pos);
            }
            this.settings.getWallFragment(rand).generate(editor, rand, this.theme, origin, dir);
        }
        Fragment.generate(Fragment.CELL_SUPPORT, editor, rand, this.theme, origin.copy());
    }

    private void mainCell(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal cellDir) {
        IStair stair = this.theme.getPrimary().getStair();
        for (Cardinal dir : Cardinal.directions) {
            BoundingBox bb = BoundingBox.of(origin.copy());
            bb.add(dir, 2).add(Cardinal.left(dir), 2).grow(Cardinal.UP, 2);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getPillar());
            bb = BoundingBox.of(origin.copy());
            bb.add(dir, 2).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir));
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
        }
        for (Cardinal o : Cardinal.orthogonal(cellDir)) {
            BlockWeightedRandom bars = new BlockWeightedRandom();
            bars.addBlock(IronBar.get(), 3);
            bars.addBlock(Air.get(), 1);
            Coord pos = origin.copy();
            pos.add(cellDir, 2).add(Cardinal.UP, 2).add(o);
            stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, pos);
            BoundingBox bb = BoundingBox.of(origin.copy());
            bb.add(o, 3).grow(cellDir, 2).grow(Cardinal.reverse(cellDir)).grow(Cardinal.UP, 3);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
            bb = BoundingBox.of(origin.copy());
            bb.add(o, 3).grow(Cardinal.orthogonal(o)).grow(Cardinal.UP, 2);
            RectSolid.fill(editor, rand, bb, bars);
        }
        BlockWeightedRandom bars = new BlockWeightedRandom();
        bars.addBlock(IronBar.get(), 2);
        bars.addBlock(Air.get(), 1);
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.reverse(cellDir), 2).grow(Cardinal.UP, 2).grow(Cardinal.orthogonal(cellDir));
        RectSolid.fill(editor, rand, bb, bars);
        Fragment.generate(Fragment.CELL_SUPPORT, editor, rand, this.theme, origin.copy());
    }

    private void doors(IWorldEditor editor, class_5819 rand, Coord origin) {
        IStair stair = this.theme.getPrimary().getStair();
        for (Cardinal dir : this.getEntrancesFromType(Entrance.DOOR)) {
            for (Cardinal o : Cardinal.orthogonal(dir)) {
                BoundingBox bb = BoundingBox.of(origin.copy());
                bb.add(dir, 8).add(o, 2).grow(Cardinal.UP, 2);
                RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
                Coord pos = origin.copy().add(dir, 8).add(o).add(Cardinal.UP, 2);
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, pos);
                pos = origin.copy().add(dir, 7).add(o, 2).add(Cardinal.UP, 2);
                stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, pos);
                pos.add(Cardinal.UP);
                this.theme.getPrimary().getWall().set(editor, rand, pos);
            }
            Fragment.generate(Fragment.ARCH, editor, rand, this.theme, origin.copy().add(dir, 6), dir);
        }
    }

    private void floor(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.DOWN).grow(Cardinal.directions, 9);
        RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getFloor());
    }

    private void outerWall(IWorldEditor editor, class_5819 rand, Coord origin) {
        for (Cardinal dir : Cardinal.directions) {
            BoundingBox bb = BoundingBox.of(origin.copy());
            bb.add(dir, 9).grow(Cardinal.orthogonal(dir), 9).grow(Cardinal.UP, 3);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall(), false, true);
            bb = BoundingBox.of(origin.copy());
            bb.add(dir, 8).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir), 8);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
        }
    }

    private void center(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox bb;
        IStair stair = this.theme.getPrimary().getStair();
        for (Cardinal dir : Cardinal.directions) {
            if (this.getEntrance(dir) != Entrance.DOOR) {
                bb = BoundingBox.of(origin.copy());
                bb.add(dir, 4).grow(Cardinal.orthogonal(dir), 3).grow(Cardinal.UP, 4);
                RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
            }
            bb = BoundingBox.of(origin.copy());
            bb.add(dir, 3).add(Cardinal.UP, 4).grow(Cardinal.orthogonal(dir), 2);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
        }
        for (Cardinal dir : Cardinal.directions) {
            if (this.getEntrance(dir) == Entrance.DOOR && this.getEntrance(Cardinal.left(dir)) == Entrance.DOOR) continue;
            bb = BoundingBox.of(origin.copy());
            bb.add(dir, 3).add(Cardinal.left(dir), 3).grow(Cardinal.UP, 4);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
            Coord pos = origin.copy();
            pos.add(dir, 3).add(Cardinal.left(dir), 3).add(Cardinal.UP, 3).add(Cardinal.right(dir));
            stair.setOrientation(Cardinal.right(dir), true).set(editor, rand, pos);
            pos.add(Cardinal.left(dir)).add(Cardinal.reverse(dir));
            stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, pos);
        }
    }

    private void clear(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.grow(Cardinal.directions, 8).grow(Cardinal.UP, 3);
        RectSolid.fill(editor, rand, bb, Air.get());
        bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.UP, 4).grow(Cardinal.directions, 2);
        RectSolid.fill(editor, rand, bb, Air.get());
    }

    @Override
    public String getName() {
        return Room.PRISON.name();
    }
}

