/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.fragment.Fragment;
import com.greymerk.roguelike.dungeon.layout.Entrance;
import com.greymerk.roguelike.dungeon.room.AbstractMediumRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.Candle;
import com.greymerk.roguelike.editor.blocks.Furnace;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.shapes.RectSolid;
import com.greymerk.roguelike.editor.shapes.Shape;
import com.greymerk.roguelike.treasure.Treasure;
import com.greymerk.roguelike.treasure.chest.ChestType;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_5819;

public class KitchenRoom
extends AbstractMediumRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        Coord pos;
        Coord origin = this.worldPos.copy().add(this.direction, 6);
        class_5819 rand = editor.getRandom(origin);
        IBlockFactory wall = this.theme.getPrimary().getWall();
        IStair stair = this.theme.getPrimary().getStair();
        IBlockFactory pillar = this.theme.getPrimary().getPillar();
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.grow(Cardinal.directions, 8).grow(Cardinal.UP, 4);
        RectSolid.fill(editor, rand, bb, Air.get());
        bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.UP, 5);
        bb.grow(Cardinal.directions, 9);
        RectSolid.fill(editor, rand, bb, wall);
        bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.DOWN);
        bb.grow(Cardinal.directions, 9);
        RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getFloor());
        Fragment.generate(Fragment.CELL_SUPPORT, editor, rand, this.theme, origin);
        Cardinal.directions.forEach(dir -> {
            Fragment.generate(Fragment.CELL_SUPPORT, editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), 6));
            Fragment.generate(Fragment.CELL_SUPPORT, editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), 6).add(Cardinal.left(dir), 6));
        });
        for (Cardinal dir2 : Cardinal.directions) {
            for (Cardinal o : Cardinal.orthogonal(dir2)) {
                bb = BoundingBox.of(origin.copy());
                bb.add(dir2, 9).add(o, 3);
                bb.grow(o, 6).grow(Cardinal.UP, 4);
                RectSolid.fill(editor, rand, bb, wall, false, true);
                bb = BoundingBox.of(origin.copy());
                bb.add(dir2, 8).add(Cardinal.UP, 3);
                bb.grow(o, 8).grow(Cardinal.UP, 2);
                RectSolid.fill(editor, rand, bb, wall);
                bb = BoundingBox.of(origin.copy());
                bb.add(dir2, 3).add(o, 2).add(Cardinal.UP, 3);
                bb.grow(Cardinal.UP, 1).grow(dir2, 4);
                RectSolid.fill(editor, rand, bb, wall);
                bb = BoundingBox.of(origin.copy());
                bb.add(dir2, 7).add(o, 3).add(Cardinal.UP, 4).grow(o, 4);
                RectSolid.fill(editor, rand, bb, wall);
                bb = BoundingBox.of(origin.copy());
                bb.add(dir2, 7).add(o, 5).add(Cardinal.UP, 3);
                bb.grow(o, 2);
                stair.setOrientation(Cardinal.reverse(dir2), true);
                bb.getShape(Shape.RECTSOLID).get().forEach(c -> stair.set(editor, rand, (Coord)c));
                Coord pos2 = origin.copy();
                pos2.add(dir2, 7).add(Cardinal.UP, 3).add(o, 3);
                stair.set(editor, rand, pos2);
                pos2.add(o);
                wall.set(editor, rand, pos2);
                bb = BoundingBox.of(origin.copy());
                bb.add(dir2, 8).add(o, 2);
                bb.grow(Cardinal.UP, 2);
                RectSolid.fill(editor, rand, bb, pillar);
                pos2 = origin.copy();
                pos2.add(dir2, 8).add(Cardinal.UP, 2).add(o);
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, pos2);
                pos2.add(o).add(Cardinal.reverse(dir2));
                stair.setOrientation(Cardinal.reverse(dir2), true).set(editor, rand, pos2);
                pos2.add(dir2).add(o);
                stair.set(editor, rand, pos2);
                pos2 = origin.copy();
                pos2.add(dir2, 2).add(o).add(Cardinal.UP, 4);
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, pos2);
            }
            bb = BoundingBox.of(origin.copy());
            bb.add(dir2, 2).add(Cardinal.left(dir2), 2);
            bb.grow(Cardinal.UP, 4);
            RectSolid.fill(editor, rand, bb, pillar);
        }
        for (Cardinal dir2 : Cardinal.directions) {
            pos = origin.copy();
            pos.add(dir2, 6);
            pos.add(Cardinal.left(dir2), 6);
            this.cornerPillars(editor, rand, pos, Cardinal.left(dir2));
            bb = BoundingBox.of(origin.copy());
            bb.add(dir2, 3).add(Cardinal.left(dir2), 3).add(Cardinal.DOWN);
            bb.grow(dir2, 4).grow(Cardinal.left(dir2), 4);
            RectSolid.fill(editor, rand, bb, this.theme.getSecondary().getFloor());
        }
        for (Cardinal dir2 : Cardinal.directions) {
            if (this.getEntrancesFromType(Entrance.DOOR).contains((Object)dir2)) {
                pos = origin.copy().add(dir2, 6);
                Fragment.generate(Fragment.ARCH, editor, rand, this.theme, pos, dir2);
                continue;
            }
            BoundingBox.of(origin).add(dir2, 9).grow(Cardinal.DOWN).grow(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir2), 2).getShape(Shape.RECTSOLID).fill(editor, rand, wall, false, true);
            if (this.getEntrance(dir2) == Entrance.WALL) {
                this.settings.getWallFragment(rand).generate(editor, rand, this.theme, origin.copy().add(dir2, 6), dir2);
            }
            if (this.getEntrance(dir2) != Entrance.ALCOVE) continue;
            Fragment.generate(Fragment.ALCOVE_FIRE, editor, rand, this.theme, origin.copy().add(dir2, 6), dir2);
        }
        boolean table = true;
        for (Cardinal dir3 : Cardinal.randDirs(rand)) {
            Coord pos3 = origin.copy();
            pos3.add(dir3, 6).add(Cardinal.left(dir3), 6);
            if (table) {
                this.table(editor, rand, pos3, Cardinal.left(dir3));
            } else {
                this.chest(editor, rand, pos3, Cardinal.left(dir3));
            }
            table = !table;
        }
    }

    private void chest(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        IStair stair = this.theme.getSecondary().getStair();
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.add(dir, 2).grow(Cardinal.orthogonal(dir));
        stair.setOrientation(Cardinal.reverse(dir), false);
        bb.getShape(Shape.RECTSOLID).get().forEach(c -> stair.set(editor, rand, (Coord)c));
        bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.right(dir), 2).grow(Cardinal.orthogonal(Cardinal.right(dir)));
        stair.setOrientation(Cardinal.left(dir), false);
        bb.getShape(Shape.RECTSOLID).get().forEach(c -> stair.set(editor, rand, (Coord)c));
        Coord pos = origin.copy();
        stair.setOrientation(dir, true).set(editor, rand, pos);
        pos.add(Cardinal.left(dir));
        stair.setOrientation(Cardinal.left(dir), true).set(editor, rand, pos);
        pos.add(Cardinal.reverse(dir));
        stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, pos);
        pos.add(Cardinal.right(dir));
        stair.setOrientation(Cardinal.right(dir), true).set(editor, rand, pos);
        pos = origin.copy().add(Cardinal.reverse(dir)).add(Cardinal.left(dir)).add(Cardinal.UP);
        Candle.generate(editor, rand, pos);
    }

    private void table(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        IStair stair = this.theme.getSecondary().getStair();
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.add(dir, 2).grow(Cardinal.orthogonal(dir));
        stair.setOrientation(Cardinal.reverse(dir), true);
        bb.getShape(Shape.RECTSOLID).get().forEach(c -> stair.set(editor, rand, (Coord)c));
        bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.right(dir), 2).grow(Cardinal.orthogonal(Cardinal.right(dir)));
        stair.setOrientation(Cardinal.left(dir), true);
        bb.getShape(Shape.RECTSOLID).get().forEach(c -> stair.set(editor, rand, (Coord)c));
        Coord pos = origin.copy();
        pos.add(Cardinal.UP).add(dir, 2);
        Treasure.generate(editor, rand, pos, Treasure.FOOD, ChestType.BARREL);
        pos = origin.copy().add(Cardinal.UP).add(Cardinal.right(dir), 2);
        Furnace.generate(editor, Cardinal.left(dir), pos, true, new class_1799((class_1935)class_1802.field_8713, rand.method_39332(1, 4)));
    }

    private void cornerPillars(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        IBlockFactory pillar = this.theme.getSecondary().getPillar();
        IStair stair = this.theme.getSecondary().getStair();
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.grow(Cardinal.UP, 2);
        bb.add(Cardinal.right(dir), 2).add(Cardinal.reverse(dir), 2);
        RectSolid.fill(editor, rand, bb, pillar);
        bb.add(dir, 4);
        RectSolid.fill(editor, rand, bb, pillar);
        bb.add(Cardinal.left(dir), 4);
        RectSolid.fill(editor, rand, bb, pillar);
        Coord pos = origin.copy();
        pos.add(Cardinal.UP, 2).add(Cardinal.right(dir), 2).add(Cardinal.reverse(dir), 2);
        Cardinal.directions.forEach(d -> stair.setOrientation((Cardinal)((Object)d), true).set(editor, rand, pos.copy().add((Cardinal)((Object)d)), true, false));
        pos.add(dir, 4);
        Cardinal.directions.forEach(d -> stair.setOrientation((Cardinal)((Object)d), true).set(editor, rand, pos.copy().add((Cardinal)((Object)d)), true, false));
        pos.add(Cardinal.left(dir), 4);
        Cardinal.directions.forEach(d -> stair.setOrientation((Cardinal)((Object)d), true).set(editor, rand, pos.copy().add((Cardinal)((Object)d)), true, false));
    }

    @Override
    public String getName() {
        return Room.KITCHEN.name();
    }
}

