/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.fragment.Fragment;
import com.greymerk.roguelike.dungeon.fragment.parts.CryptFragment;
import com.greymerk.roguelike.dungeon.layout.Entrance;
import com.greymerk.roguelike.dungeon.room.AbstractMediumRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.BlockType;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.shapes.RectHollow;
import com.greymerk.roguelike.editor.shapes.RectSolid;
import com.greymerk.roguelike.editor.shapes.Shape;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_5819;

public class CryptRoom
extends AbstractMediumRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        Coord origin = this.worldPos.copy().add(this.direction, 6);
        class_5819 rand = editor.getRandom(origin);
        this.roomCenter(editor, rand, origin);
        Fragment.generate(Fragment.CELL_SUPPORT, editor, rand, this.theme, origin.copy());
        for (Cardinal dir : Cardinal.directions) {
            if (this.getEntrance(dir) == Entrance.DOOR) {
                this.entryWay(editor, rand, origin.copy(), dir);
            } else if (rand.method_43056()) {
                this.sarcophagus(editor, rand, origin.copy().add(dir, 5), dir);
            } else {
                this.cryptWall(editor, rand, origin.copy().add(dir, 5), dir);
            }
            Fragment.generate(Fragment.CELL_SUPPORT, editor, rand, this.theme, origin.copy().add(dir, 6));
        }
        for (Cardinal dir : Cardinal.directions) {
            Coord pos;
            if (this.getEntrance(dir) != Entrance.DOOR) continue;
            if (this.getEntrance(Cardinal.left(dir)) == Entrance.DOOR) {
                pos = origin.copy().add(dir, 6).add(Cardinal.left(dir), 6);
                ArrayList<Cardinal> doors = new ArrayList<Cardinal>();
                doors.add(Cardinal.reverse(dir));
                doors.add(Cardinal.right(dir));
                this.cornerCell(editor, rand, pos, doors);
            } else {
                pos = origin.copy().add(dir, 6).add(Cardinal.left(dir), 2);
                this.entrySideWall(editor, rand, pos, Cardinal.left(dir));
            }
            if (this.getEntrance(Cardinal.right(dir)) == Entrance.DOOR) continue;
            pos = origin.copy().add(dir, 6).add(Cardinal.right(dir), 2);
            this.entrySideWall(editor, rand, pos, Cardinal.right(dir));
        }
    }

    private void sarcophagus(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        IBlockFactory walls = this.theme.getPrimary().getWall();
        IStair stair = this.theme.getPrimary().getStair();
        BoundingBox bb = BoundingBox.of(origin);
        bb.grow(dir, 3).grow(Cardinal.orthogonal(dir), 4).grow(Cardinal.UP, 4);
        RectSolid.fill(editor, rand, bb, Air.get());
        bb = BoundingBox.of(origin);
        bb.add(Cardinal.UP, 5).grow(Cardinal.orthogonal(dir), 5).grow(dir, 4);
        RectSolid.fill(editor, rand, bb, walls, false, true);
        bb = BoundingBox.of(origin);
        bb.add(Cardinal.DOWN).grow(Cardinal.orthogonal(dir), 5).grow(dir, 4);
        RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getFloor());
        bb = BoundingBox.of(origin);
        bb.add(dir, 4).grow(Cardinal.orthogonal(dir), 5).grow(Cardinal.UP, 5);
        RectSolid.fill(editor, rand, bb, walls, false, true);
        bb = BoundingBox.of(origin);
        bb.add(dir, 3).grow(Cardinal.UP, 4);
        RectSolid.fill(editor, rand, bb, walls);
        Coord pos = origin.copy().add(dir, 2).add(Cardinal.UP, 3);
        stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, pos);
        pos.add(Cardinal.UP);
        walls.set(editor, rand, pos);
        for (Cardinal o : Cardinal.orthogonal(dir)) {
            bb = BoundingBox.of(origin);
            bb.add(o, 5).grow(dir, 4).grow(Cardinal.UP, 4);
            RectSolid.fill(editor, rand, bb, walls, false, true);
            bb = BoundingBox.of(origin);
            bb.add(dir, 3).add(o, 4).grow(Cardinal.UP, 4);
            RectSolid.fill(editor, rand, bb, walls);
            bb = BoundingBox.of(origin);
            bb.add(o, 4).add(Cardinal.UP, 4).grow(dir, 2);
            RectSolid.fill(editor, rand, bb, walls);
            bb = BoundingBox.of(origin);
            bb.add(dir, 3).add(o, 4).grow(Cardinal.UP, 3);
            RectSolid.fill(editor, rand, bb, walls);
            bb = BoundingBox.of(origin);
            bb.add(dir, 3).add(o).add(Cardinal.UP, 4).grow(o, 2);
            RectSolid.fill(editor, rand, bb, walls);
            stair.setOrientation(o, true).set(editor, rand, origin.copy().add(dir, 3).add(o).add(Cardinal.UP, 3));
            stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.copy().add(dir, 3).add(o, 3).add(Cardinal.UP, 3));
            stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.copy().add(dir, 2).add(Cardinal.UP, 3).add(o, 4));
            stair.setOrientation(dir, true).set(editor, rand, origin.copy().add(Cardinal.UP, 3).add(o, 4));
        }
        Fragment.generate(Fragment.SARCOPHAGUS, editor, rand, this.theme, origin.copy(), dir);
    }

    private void entryWay(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        IStair stair = this.theme.getPrimary().getStair();
        IBlockFactory wall = this.theme.getPrimary().getWall();
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.add(dir, 5).grow(Cardinal.orthogonal(dir), 4).grow(Cardinal.UP, 3).grow(dir, 3);
        RectSolid.fill(editor, rand, bb, BlockType.get(BlockType.AIR));
        bb = BoundingBox.of(origin.copy());
        bb.add(dir, 5).add(Cardinal.DOWN).grow(Cardinal.orthogonal(dir), 4).grow(dir, 5);
        RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getFloor());
        bb = BoundingBox.of(origin.copy());
        bb.add(dir, 5).add(Cardinal.UP, 4).grow(Cardinal.orthogonal(dir), 4).grow(dir, 3);
        RectSolid.fill(editor, rand, bb, wall);
        bb = BoundingBox.of(origin.copy());
        bb.add(dir, 8).add(Cardinal.UP, 3);
        bb.grow(Cardinal.orthogonal(dir), 3);
        RectSolid.fill(editor, rand, bb, wall);
        bb.add(Cardinal.reverse(dir));
        List<Coord> lc = bb.getShape(Shape.RECTSOLID).get();
        stair.setOrientation(Cardinal.reverse(dir), true);
        lc.forEach(c -> stair.set(editor, rand, (Coord)c, true, false));
        for (Cardinal o : Cardinal.orthogonal(dir)) {
            bb = BoundingBox.of(origin.copy());
            bb.add(dir, 8).add(o, 2).grow(Cardinal.UP, 3);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getPillar());
            Coord pos = origin.copy().add(dir, 7).add(o, 2).add(Cardinal.UP, 3);
            wall.set(editor, rand, pos);
            pos.add(Cardinal.reverse(dir));
            stair.setOrientation(Cardinal.reverse(dir), true);
            stair.set(editor, rand, pos);
            pos = origin.copy().add(dir, 8).add(o).add(Cardinal.UP, 2);
            stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, pos);
            pos.add(o).add(Cardinal.reverse(dir));
            stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, pos);
            pos.add(dir).add(o);
            stair.set(editor, rand, pos);
        }
        Fragment.generate(Fragment.ARCH, editor, rand, this.theme, origin.copy().add(dir, 6), dir);
    }

    private void entrySideWall(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        IStair stair = this.theme.getPrimary().getStair();
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.add(dir, 2).grow(Cardinal.orthogonal(dir)).add(Cardinal.UP, 2);
        RectSolid.fill(editor, rand, bb, BlockType.get(BlockType.AIR));
        bb = BoundingBox.of(origin.copy());
        bb.add(dir, 2).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir));
        RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
        bb = BoundingBox.of(origin.copy());
        bb.add(dir, 3).grow(Cardinal.orthogonal(dir), 2).grow(Cardinal.UP, 3);
        RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall(), false, true);
        for (Cardinal o : Cardinal.orthogonal(dir)) {
            bb = BoundingBox.of(origin.copy());
            bb.add(dir, 2).add(o, 2).grow(Cardinal.UP, 3);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getPillar());
            Coord pos = origin.copy().add(dir, 2).add(o).add(Cardinal.UP, 2);
            stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, pos);
        }
        this.settings.getWallFragment(rand).generate(editor, rand, this.theme, origin, dir);
    }

    private void cornerCell(IWorldEditor editor, class_5819 rand, Coord origin, List<Cardinal> doors) {
        IStair stair = this.theme.getPrimary().getStair();
        BoundingBox bb = BoundingBox.of(origin.copy()).grow(Cardinal.directions, 2).grow(Cardinal.UP, 3);
        RectSolid.fill(editor, rand, bb, BlockType.get(BlockType.AIR));
        bb = BoundingBox.of(origin).add(Cardinal.DOWN).grow(Cardinal.directions);
        RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getFloor());
        for (Cardinal dir : Cardinal.directions) {
            bb = BoundingBox.of(origin.copy()).add(dir, 2).add(Cardinal.left(dir), 2).grow(Cardinal.UP, 3);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getPillar());
            bb = BoundingBox.of(origin.copy()).add(dir, 2).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir));
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
            for (Cardinal o : Cardinal.orthogonal(dir)) {
                Coord pos = origin.copy().add(dir, 2).add(Cardinal.UP, 2).add(o);
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, pos);
            }
            if (doors.contains((Object)dir)) continue;
            bb = BoundingBox.of(origin.copy());
            bb.add(dir, 3).grow(Cardinal.orthogonal(dir), 2).grow(Cardinal.UP, 3);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall(), false, true);
            this.settings.getWallFragment(rand).generate(editor, rand, this.theme, origin.copy(), dir);
        }
    }

    private void roomCenter(IWorldEditor editor, class_5819 rand, Coord origin) {
        IStair stair = this.theme.getPrimary().getStair();
        IBlockFactory wall = this.theme.getPrimary().getWall();
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.UP, 4).grow(Cardinal.UP, 3).grow(Cardinal.directions, 4);
        RectHollow.fill(editor, rand, bb, wall);
        bb = BoundingBox.of(origin.copy());
        bb.grow(Cardinal.UP, 4).grow(Cardinal.directions, 4);
        RectSolid.fill(editor, rand, bb, BlockType.get(BlockType.AIR));
        for (Cardinal dir : Cardinal.directions) {
            bb = BoundingBox.of(origin.copy());
            bb.add(dir, 4).add(Cardinal.left(dir), 4).grow(Cardinal.UP, 4);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getPillar());
            for (Cardinal d : Cardinal.directions) {
                Coord pos = origin.copy().add(dir, 4).add(Cardinal.left(dir), 4).add(Cardinal.UP, 4).add(d);
                stair.setOrientation(d, true).set(editor, rand, pos);
            }
        }
        Coord pos = origin.copy().add(Cardinal.UP, 6);
        for (Cardinal dir : Cardinal.directions) {
            Coord p = pos.copy().add(dir, 3);
            RectSolid.fill(editor, rand, BoundingBox.of(pos, p), wall);
            p.add(Cardinal.DOWN);
            stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, p);
        }
        bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.DOWN).grow(Cardinal.directions, 4);
        RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getFloor());
    }

    private void cryptWall(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.grow(Cardinal.orthogonal(dir), 4).grow(Cardinal.DOWN).grow(Cardinal.UP, 5).grow(dir, 3);
        RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
        Coord pos = origin.copy().add(Cardinal.UP);
        this.crypt(editor, rand, pos, dir);
        pos.add(Cardinal.UP, 2);
        this.crypt(editor, rand, pos, dir);
        for (Cardinal o : Cardinal.orthogonal(dir)) {
            pos = origin.copy().add(o, 2).add(Cardinal.UP);
            this.crypt(editor, rand, pos, dir);
            pos.add(Cardinal.UP, 2);
            this.crypt(editor, rand, pos, dir);
        }
    }

    private void crypt(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        CryptFragment crypt = new CryptFragment(rand.method_43048(5) != 0);
        crypt.generate(editor, rand, this.theme, origin.copy(), dir);
    }

    @Override
    public String getName() {
        return Room.CRYPT.name();
    }
}

