/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.fragment.Fragment;
import com.greymerk.roguelike.dungeon.fragment.IFragment;
import com.greymerk.roguelike.dungeon.layout.Entrance;
import com.greymerk.roguelike.dungeon.room.AbstractRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.shapes.RectHollow;
import com.greymerk.roguelike.editor.shapes.RectSolid;
import com.greymerk.roguelike.theme.ITheme;
import net.minecraft.class_5819;

public class Corridor
extends AbstractRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        class_5819 rand = editor.getRandom(this.worldPos);
        IBlockFactory blocks = this.theme.getPrimary().getWall();
        IStair stairs = this.theme.getPrimary().getStair();
        BoundingBox bb = BoundingBox.of(this.worldPos);
        bb.grow(Cardinal.directions, 3).grow(Cardinal.DOWN).grow(Cardinal.UP, 3);
        RectHollow.fill(editor, rand, bb, blocks, false, true);
        bb = BoundingBox.of(this.worldPos);
        bb.grow(Cardinal.directions).add(Cardinal.UP, 3);
        RectSolid.fill(editor, rand, bb, Air.get());
        bb.add(Cardinal.UP);
        RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall(), false, true);
        for (Cardinal dir : Cardinal.directions) {
            bb = BoundingBox.of(this.worldPos);
            bb.add(dir, 2).add(Cardinal.left(dir), 2).grow(Cardinal.UP, 2);
            RectSolid.fill(editor, rand, bb, this.theme.getSecondary().getPillar());
            bb.add(Cardinal.UP, 2);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
            bb = BoundingBox.of(this.worldPos);
            bb.add(dir, 2).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir));
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
            bb = BoundingBox.of(this.worldPos);
            bb.add(dir, 2).add(Cardinal.DOWN).grow(Cardinal.orthogonal(dir)).grow(Cardinal.left(dir));
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
            for (Cardinal orth : Cardinal.orthogonal(dir)) {
                Coord pos = this.worldPos.copy();
                pos.add(dir, 2);
                pos.add(orth);
                pos.add(Cardinal.UP, 2);
                stairs.setOrientation(Cardinal.reverse(orth), true).set(editor, rand, pos);
            }
            Fragment.generate(Fragment.CELL_SUPPORT, editor, rand, this.theme, this.worldPos.copy());
        }
        bb = BoundingBox.of(this.worldPos);
        bb.add(Cardinal.DOWN);
        bb.grow(Cardinal.directions);
        RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getFloor());
        for (Cardinal dir : Cardinal.directions) {
            Coord pos = this.worldPos.copy();
            pos.add(Cardinal.DOWN);
            pos.add(dir, 2);
            this.crossBar(editor, rand, this.theme, pos, dir);
        }
        for (Cardinal dir : Cardinal.directions) {
            if (this.getEntrance(dir) == Entrance.DOOR) {
                Fragment.generate(Fragment.ARCH, editor, rand, this.theme, this.worldPos.copy(), dir);
                continue;
            }
            if (this.getEntrance(dir) == Entrance.ALCOVE) {
                IFragment alcove = this.settings.getAlcove(rand);
                alcove.generate(editor, rand, this.theme, this.worldPos.copy(), dir);
                continue;
            }
            IFragment wall = this.settings.getWallFragment(rand);
            wall.generate(editor, rand, this.theme, this.worldPos.copy(), dir);
        }
    }

    private void crossBar(IWorldEditor editor, class_5819 rand, ITheme theme, Coord origin, Cardinal dir) {
        IBlockFactory wall = theme.getPrimary().getWall();
        IStair stair = theme.getPrimary().getStair();
        wall.set(editor, rand, origin, true, true);
        for (Cardinal o : Cardinal.orthogonal(dir)) {
            Coord pos = origin.copy();
            pos.add(o);
            wall.set(editor, rand, pos, true, true);
            pos.add(Cardinal.DOWN);
            stair.setOrientation(Cardinal.reverse(o), true);
            stair.set(editor, rand, pos, true, false);
        }
    }

    @Override
    public String getName() {
        return Room.CORRIDOR.name();
    }
}

