/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.fragment.Fragment;
import com.greymerk.roguelike.dungeon.layout.Entrance;
import com.greymerk.roguelike.dungeon.room.AbstractMediumRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.IronBar;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.boundingbox.IBounded;
import com.greymerk.roguelike.editor.shapes.RectSolid;
import net.minecraft.class_5819;

public class CisternRoom
extends AbstractMediumRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        class_5819 rand = editor.getRandom(this.worldPos);
        Coord origin = this.worldPos.copy().add(this.direction, 6);
        this.clear(editor, rand, origin);
        this.walls(editor, rand, origin);
        this.bridges(editor, rand, origin);
        this.water(editor, rand, origin);
        this.ceiling(editor, rand, origin);
        this.supports(editor, rand, origin);
    }

    private void supports(IWorldEditor editor, class_5819 rand, Coord origin) {
        Fragment.generate(Fragment.CELL_SUPPORT, editor, rand, this.theme, origin.copy().add(Cardinal.DOWN));
        for (Cardinal dir : Cardinal.directions) {
            Coord pos = origin.copy().add(Cardinal.DOWN);
            pos.add(dir, 6);
            Fragment.generate(Fragment.CELL_SUPPORT, editor, rand, this.theme, pos);
            pos.add(Cardinal.left(dir), 6);
            Fragment.generate(Fragment.CELL_SUPPORT, editor, rand, this.theme, pos);
        }
    }

    private void ceiling(IWorldEditor editor, class_5819 rand, Coord origin) {
        IBlockFactory wall = this.theme.getPrimary().getWall();
        for (Cardinal dir : Cardinal.directions) {
            BoundingBox bb = BoundingBox.of(origin.copy());
            bb.add(Cardinal.UP, 5);
            bb.add(dir, 6);
            bb.grow(dir);
            bb.grow(Cardinal.left(dir), 5);
            bb.grow(Cardinal.right(dir), 7);
            RectSolid.fill(editor, rand, bb, wall);
            bb = BoundingBox.of(origin.copy());
            bb.add(Cardinal.UP, 5);
            bb.add(dir, 2);
            bb.grow(Cardinal.orthogonal(dir), 5);
            RectSolid.fill(editor, rand, bb, wall, true, false);
        }
    }

    private void water(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.DOWN, 2);
        bb.grow(Cardinal.directions, 9);
        RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
        bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.DOWN);
        bb.grow(Cardinal.directions, 7);
        RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getLiquid(), true, false);
    }

    private void bridges(IWorldEditor editor, class_5819 rand, Coord origin) {
        Coord pos;
        IBlockFactory floor = this.theme.getPrimary().getFloor();
        IBlockFactory wall = this.theme.getPrimary().getWall();
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.DOWN);
        bb.grow(Cardinal.directions, 2);
        RectSolid.fill(editor, rand, bb, wall);
        bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.DOWN);
        bb.grow(Cardinal.directions);
        RectSolid.fill(editor, rand, bb, floor);
        for (Cardinal dir : this.getEntrancesFromType(Entrance.DOOR)) {
            bb = BoundingBox.of(origin.copy());
            bb.add(dir, 3);
            bb.add(Cardinal.DOWN);
            bb.grow(Cardinal.orthogonal(dir), 2);
            bb.grow(dir, 4);
            RectSolid.fill(editor, rand, bb, wall);
            bb.grow(Cardinal.orthogonal(dir), -1);
            RectSolid.fill(editor, rand, bb, floor);
        }
        for (Cardinal dir : Cardinal.directions) {
            pos = origin.copy();
            pos.add(dir, 2);
            pos.add(Cardinal.left(dir), 2);
            wall.set(editor, rand, pos);
            if (this.getEntrance(dir) != Entrance.DOOR) {
                bb = BoundingBox.of(origin.copy());
                bb.add(dir, 2);
                bb.grow(Cardinal.orthogonal(dir));
                RectSolid.fill(editor, rand, bb, IronBar.get());
                continue;
            }
            for (Cardinal o : Cardinal.orthogonal(dir)) {
                bb = BoundingBox.of(origin.copy());
                bb.add(dir, 3);
                bb.add(o, 2);
                bb.grow(dir, 4);
                RectSolid.fill(editor, rand, bb, IronBar.get());
            }
        }
        for (Cardinal dir : this.getEntrancesFromType(Entrance.DOOR)) {
            pos = origin.copy();
            pos.add(dir, 6);
            Fragment.generate(Fragment.ARCH, editor, rand, this.theme, pos, dir);
        }
    }

    private void walls(IWorldEditor editor, class_5819 rand, Coord origin) {
        Object bb;
        IStair stair = this.theme.getPrimary().getStair();
        for (Cardinal dir : Cardinal.directions) {
            bb = BoundingBox.of(origin.copy());
            ((BoundingBox)bb).add(Cardinal.DOWN);
            ((BoundingBox)bb).add(dir, 8);
            ((BoundingBox)bb).grow(Cardinal.orthogonal(dir), 8);
            RectSolid.fill(editor, rand, (IBounded)bb, this.theme.getPrimary().getWall());
            ((BoundingBox)bb).add(Cardinal.UP, 4);
            ((BoundingBox)bb).grow(Cardinal.UP, 2);
            RectSolid.fill(editor, rand, (IBounded)bb, this.theme.getPrimary().getWall());
        }
        for (Cardinal dir : Cardinal.directions) {
            for (Cardinal o : Cardinal.orthogonal(dir)) {
                Coord pos = origin.copy();
                pos.add(o, 3);
                pos.add(dir, 6);
                this.wallPillarPiece(editor, rand, pos.copy(), dir);
            }
        }
        for (Cardinal dir : Cardinal.directions) {
            bb = BoundingBox.of(origin.copy());
            ((BoundingBox)bb).add(dir, 8);
            ((BoundingBox)bb).add(Cardinal.left(dir), 8);
            ((BoundingBox)bb).grow(Cardinal.UP, 2);
            RectSolid.fill(editor, rand, (IBounded)bb, this.theme.getPrimary().getPillar());
            for (Cardinal d : Cardinal.directions) {
                Coord pos = origin.copy();
                pos.add(dir, 8).add(Cardinal.left(dir), 8).add(Cardinal.UP, 2);
                pos.add(d);
                stair.setOrientation(d, true);
                stair.set(editor, rand, pos, true, false);
            }
            bb = BoundingBox.of(origin.copy());
            ((BoundingBox)bb).add(dir, 8).add(Cardinal.left(dir), 8);
            ((BoundingBox)bb).grow(Cardinal.UP);
            ((BoundingBox)bb).add(Cardinal.reverse(dir));
            ((BoundingBox)bb).add(Cardinal.right(dir));
            ((BoundingBox)bb).add(Cardinal.UP, 3);
            RectSolid.fill(editor, rand, (IBounded)bb, this.theme.getPrimary().getWall());
        }
        for (Cardinal dir : Cardinal.directions) {
            Coord pos = origin.copy();
            pos.add(dir, 6);
            if (this.entrances.get((Object)dir) == Entrance.WALL) {
                this.settings.getWallFragment(rand).generate(editor, rand, this.theme, pos.copy(), dir);
            }
            pos.add(Cardinal.left(dir), 6);
            this.settings.getWallFragment(rand).generate(editor, rand, this.theme, pos.copy(), dir);
            this.settings.getWallFragment(rand).generate(editor, rand, this.theme, pos.copy(), Cardinal.left(dir));
        }
    }

    private void wallPillarPiece(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        IStair stair = this.theme.getPrimary().getStair();
        Coord pos = origin.copy();
        pos.add(dir, 2);
        pos.add(Cardinal.UP, 2);
        stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, pos);
        pos.add(Cardinal.UP, 2);
        pos.add(Cardinal.reverse(dir));
        stair.set(editor, rand, pos);
        for (Cardinal o : Cardinal.orthogonal(dir)) {
            BoundingBox bb = BoundingBox.of(origin.copy());
            bb.add(dir, 2);
            bb.add(o);
            bb.grow(Cardinal.UP, 3);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getPillar());
            bb = BoundingBox.of(origin.copy());
            bb.add(dir);
            bb.add(o);
            bb.add(Cardinal.UP, 3);
            bb.grow(Cardinal.UP);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getPillar());
            pos = origin.copy();
            pos.add(dir);
            pos.add(o);
            pos.add(Cardinal.UP, 2);
            stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, pos);
            pos.add(Cardinal.reverse(dir));
            pos.add(Cardinal.UP, 2);
            stair.set(editor, rand, pos);
            pos.add(dir);
            pos.add(o);
            stair.setOrientation(o, true).set(editor, rand, pos);
            pos.add(Cardinal.DOWN, 2);
            pos.add(dir);
            stair.set(editor, rand, pos);
        }
    }

    private void clear(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.DOWN);
        bb.grow(Cardinal.UP, 6);
        bb.grow(Cardinal.directions, 8);
        RectSolid.fill(editor, rand, bb, Air.get(), false, true);
    }

    @Override
    public String getName() {
        return Room.CISTERN.name();
    }
}

