/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.fragment.parts;

import com.greymerk.roguelike.dungeon.fragment.IFragment;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.slab.ISlab;
import com.greymerk.roguelike.editor.blocks.spawners.Spawner;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.theme.ITheme;
import com.greymerk.roguelike.treasure.Treasure;
import com.greymerk.roguelike.util.math.RandHelper;
import java.util.ArrayList;
import net.minecraft.class_5819;

public class Sarcophagus
implements IFragment {
    @Override
    public void generate(IWorldEditor editor, class_5819 rand, ITheme theme, Coord origin, Cardinal dir) {
        IBlockFactory walls = theme.getPrimary().getWall();
        IStair stair = theme.getPrimary().getStair();
        ISlab slab = theme.getPrimary().getSlab();
        Coord pos = origin.copy();
        walls.set(editor, rand, pos);
        pos.add(Cardinal.UP, 2);
        slab.upsideDown(true).set(editor, pos);
        for (Cardinal o : Cardinal.orthogonal(Cardinal.left(dir))) {
            pos = origin.copy().add(o);
            stair.setOrientation(o, false).set(editor, rand, pos);
            pos.add(Cardinal.UP);
            stair.setOrientation(o, true).set(editor, rand, pos);
            pos.add(Cardinal.UP);
            stair.setOrientation(o, false).set(editor, rand, pos);
        }
        for (Cardinal orth : Cardinal.orthogonal(dir)) {
            pos = origin.copy().add(orth);
            walls.set(editor, rand, pos);
            pos.add(orth);
            stair.setOrientation(orth, false).set(editor, rand, pos);
            pos.add(Cardinal.UP);
            stair.setOrientation(orth, true).set(editor, rand, pos);
            pos.add(Cardinal.UP);
            stair.setOrientation(orth, false).set(editor, rand, pos);
            pos.add(Cardinal.reverse(orth));
            slab.upsideDown(true).set(editor, pos);
            for (Cardinal o : Cardinal.orthogonal(orth)) {
                pos = origin.copy().add(orth).add(o);
                stair.setOrientation(o, false).set(editor, rand, pos);
                pos.add(orth);
                stair.setOrientation(o, false).set(editor, rand, pos);
                pos.add(Cardinal.UP);
                stair.setOrientation(o, true).set(editor, rand, pos);
                pos.add(Cardinal.reverse(orth));
                stair.setOrientation(o, true).set(editor, rand, pos);
                pos.add(Cardinal.UP);
                stair.setOrientation(o, false).set(editor, rand, pos);
                pos.add(orth);
                stair.setOrientation(o, false).set(editor, rand, pos);
            }
        }
        Spawner type = rand.method_43056() ? Spawner.SKELETON : Spawner.ZOMBIE;
        Spawner.generate(editor, rand, origin.copy().add(Cardinal.UP), type);
        ArrayList<Cardinal> dirs = new ArrayList<Cardinal>(Cardinal.orthogonal(dir));
        RandHelper.shuffle(dirs, rand);
        pos = origin.copy().add(Cardinal.UP).add((Cardinal)((Object)dirs.get(0)));
        Treasure.generate(editor, rand, pos, (Cardinal)((Object)dirs.get(0)), Treasure.ARMOR);
        pos = origin.copy().add(Cardinal.UP).add((Cardinal)((Object)dirs.get(1)));
        Treasure.generate(editor, rand, pos, (Cardinal)((Object)dirs.get(1)), Treasure.WEAPON);
    }
}

