/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.fragment.parts;

import com.greymerk.roguelike.dungeon.fragment.IFragment;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.BlockType;
import com.greymerk.roguelike.editor.blocks.Quartz;
import com.greymerk.roguelike.editor.blocks.spawners.Spawner;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.theme.ITheme;
import com.greymerk.roguelike.treasure.Treasure;
import net.minecraft.class_5819;

public class CryptFragment
implements IFragment {
    boolean empty;

    public CryptFragment() {
        this.empty = false;
    }

    public CryptFragment(boolean empty) {
        this.empty = empty;
    }

    public void setEmpty(boolean e) {
        this.empty = e;
    }

    @Override
    public void generate(IWorldEditor editor, class_5819 rand, ITheme theme, Coord origin, Cardinal dir) {
        Enum type;
        if (this.empty && rand.method_43056()) {
            BlockType.get(BlockType.AIR).set(editor, origin);
        } else {
            Quartz.get(Quartz.SMOOTH).set(editor, origin);
        }
        Coord pos = origin.copy();
        pos.add(dir);
        if (this.empty) {
            BlockType.get(BlockType.AIR).set(editor, pos);
        } else {
            type = rand.method_43056() ? Spawner.SKELETON : Spawner.ZOMBIE;
            Spawner.generate(editor, rand, pos, (Spawner)type);
        }
        pos.add(dir);
        if (this.empty) {
            BlockType.get(BlockType.AIR).set(editor, pos);
        } else {
            type = rand.method_43056() ? Treasure.ARMOR : Treasure.WEAPON;
            Treasure.generate(editor, rand, pos, Cardinal.reverse(dir), (Treasure)type);
        }
        pos.add(Cardinal.UP);
        IStair stair = theme.getPrimary().getStair();
        stair.setOrientation(Cardinal.reverse(dir), true);
        stair.set(editor, rand, pos);
        pos.add(Cardinal.reverse(dir));
        stair.setOrientation(dir, true);
        stair.set(editor, rand, pos);
    }
}

