/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.fragment;

import com.greymerk.roguelike.dungeon.fragment.IFragment;
import com.greymerk.roguelike.dungeon.fragment.alcove.BookShelfAlcove;
import com.greymerk.roguelike.dungeon.fragment.alcove.FireAlcove;
import com.greymerk.roguelike.dungeon.fragment.alcove.SafetyCell;
import com.greymerk.roguelike.dungeon.fragment.alcove.SilverfishNest;
import com.greymerk.roguelike.dungeon.fragment.alcove.TombAlcove;
import com.greymerk.roguelike.dungeon.fragment.parts.ArchWay;
import com.greymerk.roguelike.dungeon.fragment.parts.CellSupportBeamFragment;
import com.greymerk.roguelike.dungeon.fragment.parts.CryptFragment;
import com.greymerk.roguelike.dungeon.fragment.parts.Sarcophagus;
import com.greymerk.roguelike.dungeon.fragment.wall.WallBannerFragment;
import com.greymerk.roguelike.dungeon.fragment.wall.WallCandles;
import com.greymerk.roguelike.dungeon.fragment.wall.WallChest;
import com.greymerk.roguelike.dungeon.fragment.wall.WallDecoratedPot;
import com.greymerk.roguelike.dungeon.fragment.wall.WallEmpty;
import com.greymerk.roguelike.dungeon.fragment.wall.WallFlowers;
import com.greymerk.roguelike.dungeon.fragment.wall.WallFoodBarrel;
import com.greymerk.roguelike.dungeon.fragment.wall.WallPlant;
import com.greymerk.roguelike.dungeon.fragment.wall.WallSpawner;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.theme.ITheme;
import net.minecraft.class_5819;

public enum Fragment {
    CRYPT,
    SARCOPHAGUS,
    CELL_SUPPORT,
    ARCH,
    WALL_FLOWER,
    WALL_BANNER,
    WALL_CHEST,
    WALL_SPAWNER,
    WALL_CANDLES,
    WALL_EMPTY,
    WALL_DECORATED_POT,
    WALL_FOOD_BARREL,
    WALL_PLANT,
    ALCOVE_SILVERFISH,
    ALCOVE_SAFETY,
    ALCOVE_CRYPT,
    BOOK_SHELF,
    ALCOVE_FIRE;


    public static void generate(Fragment type, IWorldEditor editor, class_5819 rand, ITheme theme, Coord pos) {
        Fragment.generate(type, editor, rand, theme, pos, Cardinal.DOWN);
    }

    public static void generate(Fragment type, IWorldEditor editor, class_5819 rand, ITheme theme, Coord pos, Cardinal dir) {
        IFragment fragment = Fragment.fromType(type);
        fragment.generate(editor, rand, theme, pos, dir);
    }

    public static IFragment fromType(Fragment type) {
        switch (type.ordinal()) {
            case 2: {
                return new CellSupportBeamFragment();
            }
            case 0: {
                return new CryptFragment();
            }
            case 1: {
                return new Sarcophagus();
            }
            case 3: {
                return new ArchWay();
            }
            case 4: {
                return new WallFlowers();
            }
            case 5: {
                return new WallBannerFragment();
            }
            case 7: {
                return new WallSpawner();
            }
            case 6: {
                return new WallChest();
            }
            case 8: {
                return new WallCandles();
            }
            case 9: {
                return new WallEmpty();
            }
            case 10: {
                return new WallDecoratedPot();
            }
            case 16: {
                return new BookShelfAlcove();
            }
            case 11: {
                return new WallFoodBarrel();
            }
            case 12: {
                return new WallPlant();
            }
            case 13: {
                return new SilverfishNest();
            }
            case 14: {
                return new SafetyCell();
            }
            case 15: {
                return new TombAlcove();
            }
            case 17: {
                return new FireAlcove();
            }
        }
        return new WallEmpty();
    }
}

