/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.api.ingredients;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface IIngredientHelper<V> {
    public IIngredientType<V> getIngredientType();

    public String getDisplayName(V var1);

    public String getUniqueId(V var1, UidContext var2);

    default public String getWildcardId(V ingredient) {
        return this.getUniqueId(ingredient, UidContext.Ingredient);
    }

    default public String getDisplayModId(V ingredient) {
        return this.getResourceLocation(ingredient).m_135827_();
    }

    default public Iterable<Integer> getColors(V ingredient) {
        return Collections.emptyList();
    }

    public ResourceLocation getResourceLocation(V var1);

    default public ItemStack getCheatItemStack(V ingredient) {
        return ItemStack.f_41583_;
    }

    public V copyIngredient(V var1);

    default public V normalizeIngredient(V ingredient) {
        return this.copyIngredient(ingredient);
    }

    default public boolean isValidIngredient(V ingredient) {
        return true;
    }

    default public boolean isIngredientOnServer(V ingredient) {
        return true;
    }

    default public Stream<ResourceLocation> getTagStream(V ingredient) {
        return Stream.empty();
    }

    public String getErrorInfo(@Nullable V var1);

    default public Optional<ResourceLocation> getTagEquivalent(Collection<V> ingredients) {
        return Optional.empty();
    }
}

