/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.radiantgear;

import com.illusivesoulworks.radiantgear.integration.arsnouveau.ArsNouveauModule;
import com.illusivesoulworks.radiantgear.integration.dynamiclights.DynamicLightsModule;
import com.illusivesoulworks.radiantgear.integration.dynamiclightsreforged.DLReforgedModule;
import com.illusivesoulworks.radiantgear.integration.embeddiumplus.EmbeddiumPlusModule;
import com.illusivesoulworks.radiantgear.integration.ryoamiclights.RyoamicModule;
import java.util.Objects;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

@Mod(value="radiantgear")
public class RadiantGearForgeMod {
    private static boolean isDynamicLightsLoaded = false;
    private static boolean isDLReforgedLoaded = false;
    private static boolean isArsNouveauLoaded = false;
    private static boolean isRyoamicLoaded = false;
    private static boolean isEmbeddiumPlusLoaded = false;

    public RadiantGearForgeMod() {
        ModList modList = ModList.get();
        isDynamicLightsLoaded = modList.isLoaded("dynamiclights");
        isDLReforgedLoaded = modList.isLoaded("dynamiclightsreforged");
        isArsNouveauLoaded = modList.isLoaded("ars_nouveau");
        isRyoamicLoaded = modList.isLoaded("ryoamiclights");
        if (modList.isLoaded("embeddiumplus")) {
            DefaultArtifactVersion maxVersion = new DefaultArtifactVersion("1.2.4");
            DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(modList.getModFileById("embeddiumplus").versionString());
            isEmbeddiumPlusLoaded = currentVersion.compareTo((ArtifactVersion)maxVersion) < 0;
        }
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        ModLoadingContext context = ModLoadingContext.get();
        context.registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> this.getRemoteVersion(context), (incoming, isNetwork) -> this.acceptsServer(context, (String)incoming)));
    }

    private void setup(FMLCommonSetupEvent evt) {
        if (isDynamicLightsLoaded) {
            DynamicLightsModule.setup();
        }
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        if (isDLReforgedLoaded) {
            DLReforgedModule.setup();
        }
        if (isRyoamicLoaded) {
            RyoamicModule.setup();
        }
        if (isEmbeddiumPlusLoaded) {
            EmbeddiumPlusModule.setup();
        }
        if (isArsNouveauLoaded) {
            ArsNouveauModule.setup();
        }
    }

    private String getRemoteVersion(ModLoadingContext context) {
        if (isDynamicLightsLoaded) {
            return context.getActiveContainer().getModInfo().getVersion().toString();
        }
        return "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31";
    }

    private boolean acceptsServer(ModLoadingContext context, String incoming) {
        if (isDynamicLightsLoaded) {
            return Objects.equals(incoming, context.getActiveContainer().getModInfo().getVersion().toString());
        }
        return true;
    }
}

