/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.pneumono.pneumonocore.datagen.AbstractConfigCondition;
import net.pneumono.pneumonocore.datagen.enums.ConditionType;

public class OrConfigCondition
extends AbstractConfigCondition {
    private final AbstractConfigCondition[] conditions;

    public OrConfigCondition(AbstractConfigCondition ... conditions) {
        super(ConditionType.OR);
        this.conditions = conditions;
    }

    @Override
    public boolean conditionFulfilled() {
        boolean fulfilled = this.conditions.length == 0;
        for (AbstractConfigCondition condition : this.conditions) {
            if (!condition.conditionFulfilled()) continue;
            fulfilled = true;
            break;
        }
        return fulfilled;
    }

    @Override
    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("type", this.getType().toString());
        JsonArray array = new JsonArray();
        for (AbstractConfigCondition condition : this.conditions) {
            array.add((JsonElement)condition.toJson());
        }
        object.add("conditions", (JsonElement)array);
        return object;
    }
}

