/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config.entries;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config.ConfigOptionsScreen;
import net.pneumono.pneumonocore.config.ConfigsListWidget;
import net.pneumono.pneumonocore.config.TimeConfiguration;
import net.pneumono.pneumonocore.config.TimeUnit;
import net.pneumono.pneumonocore.config.entries.AbstractConfigurationEntry;

@Environment(value=EnvType.CLIENT)
public class TimeConfigurationEntry
extends AbstractConfigurationEntry {
    private final class_342 textWidget;
    private long amount;
    private final class_4185 cycleWidget;
    private TimeUnit units;

    public TimeConfigurationEntry(AbstractConfiguration<?> configuration, ConfigOptionsScreen parent, ConfigsListWidget widget) {
        super(configuration, parent, widget);
        Supplier<TimeConfiguration> configValueSupplier = () -> {
            TimeConfiguration timeConfiguration;
            return configuration instanceof TimeConfiguration ? (timeConfiguration = (TimeConfiguration)configuration) : null;
        };
        this.amount = this.getAmount((Long)configValueSupplier.get().getValue());
        this.textWidget = new class_342(Objects.requireNonNull(parent.getClient()).field_1772, 0, 0, 85, 20, null, (class_2561)class_2561.method_43471((String)configuration.getTranslationKey()));
        this.textWidget.method_1852(String.valueOf(this.amount));
        this.textWidget.method_1863(text -> {
            this.parent.selectedConfiguration = configuration;
            try {
                long newValue = Long.parseLong(text) * (long)this.units.getDivision();
                ConfigOptionsScreen.save(configuration.getModID(), configuration.getName(), newValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.units = TimeUnit.fromValue((Long)configValueSupplier.get().getValue());
        Supplier<Long> amountSupplier = () -> this.amount;
        this.cycleWidget = class_4185.method_46430((class_2561)this.configName, button -> {
            this.parent.selectedConfiguration = configuration;
            this.units = this.cycle(this.units);
            long newValue = (Long)amountSupplier.get() * (long)this.units.getDivision();
            ConfigOptionsScreen.save(configuration.getModID(), configuration.getName(), newValue);
            this.widget.update();
        }).method_46434(0, 0, 20, 20).method_46431();
        this.update();
    }

    private long getAmount(long value) {
        return this.getAmount(value, TimeUnit.fromValue(value));
    }

    private long getAmount(long value, TimeUnit timeUnit) {
        return value / (long)timeUnit.getDivision();
    }

    private TimeUnit cycle(TimeUnit value) {
        TimeUnit[] enumConstants = (TimeUnit[])value.getDeclaringClass().getEnumConstants();
        for (int i = 0; i < enumConstants.length; ++i) {
            TimeUnit enumConstant = enumConstants[i];
            if (enumConstant != value) continue;
            return enumConstants[i + 1 >= enumConstants.length ? 0 : i + 1];
        }
        return value;
    }

    @Override
    public void update() {
        try {
            this.amount = Long.parseLong(this.textWidget.method_1882());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String key = "configs_screen.pneumonocore." + this.units.name().toLowerCase();
        this.cycleWidget.method_25355((class_2561)class_2561.method_43471((String)key));
        this.cycleWidget.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)(key + ".full"))));
    }

    @Override
    public void reset() {
        AbstractConfiguration abstractConfiguration = this.configuration;
        if (abstractConfiguration instanceof TimeConfiguration) {
            TimeConfiguration timeConfiguration = (TimeConfiguration)abstractConfiguration;
            this.amount = this.getAmount((Long)timeConfiguration.getDefaultValue());
            this.textWidget.method_1852(String.valueOf(this.amount));
            this.units = TimeUnit.fromValue((Long)timeConfiguration.getDefaultValue());
            ConfigOptionsScreen.save(this.configuration.getModID(), this.configuration.getName(), this.configuration.getDefaultValue());
        }
        this.update();
    }

    public List<? extends class_6379> method_37025() {
        return ImmutableList.of((Object)this.textWidget, (Object)this.cycleWidget);
    }

    public List<? extends class_364> method_25396() {
        return ImmutableList.of((Object)this.textWidget, (Object)this.cycleWidget);
    }

    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.renderNameAndInformation(context, x, y, entryHeight, mouseX, mouseY, tickDelta);
        this.textWidget.method_46421(x + 90);
        this.textWidget.method_46419(y);
        this.textWidget.method_25394(context, mouseX, mouseY, tickDelta);
        this.cycleWidget.method_46421(x + 180);
        this.cycleWidget.method_46419(y);
        this.cycleWidget.method_25394(context, mouseX, mouseY, tickDelta);
    }
}

