/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.api.layered;

import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.core.util.Pair;
import dev.kosmx.playerAnim.core.util.Vec3f;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class AnimationStack
implements IAnimation {
    private final ArrayList<Pair<Integer, IAnimation>> layers = new ArrayList();

    @Override
    public boolean isActive() {
        for (Pair<Integer, IAnimation> layer : this.layers) {
            if (!layer.getRight().isActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        for (Pair<Integer, IAnimation> layer : this.layers) {
            if (!layer.getRight().isActive()) continue;
            layer.getRight().tick();
        }
    }

    @Override
    @NotNull
    public Vec3f get3DTransform(@NotNull String modelName, @NotNull TransformType type, float tickDelta, @NotNull Vec3f value0) {
        for (Pair<Integer, IAnimation> layer : this.layers) {
            if (!layer.getRight().isActive() || FirstPersonMode.isFirstPersonPass() && !layer.getRight().getFirstPersonMode(tickDelta).isEnabled()) continue;
            value0 = layer.getRight().get3DTransform(modelName, type, tickDelta, value0);
        }
        return value0;
    }

    @Override
    public void setupAnim(float tickDelta) {
        for (Pair<Integer, IAnimation> layer : this.layers) {
            layer.getRight().setupAnim(tickDelta);
        }
    }

    public void addAnimLayer(int priority, IAnimation layer) {
        int search;
        for (search = 0; this.layers.size() > search && this.layers.get(search).getLeft() < priority; ++search) {
        }
        this.layers.add(search, new Pair<Integer, IAnimation>(priority, layer));
    }

    public boolean removeLayer(IAnimation layer) {
        return this.layers.removeIf(integerIAnimationPair -> integerIAnimationPair.getRight() == layer);
    }

    public boolean removeLayer(int layerLevel) {
        return this.layers.removeIf(integerIAnimationPair -> (Integer)integerIAnimationPair.getLeft() == layerLevel);
    }

    @Override
    @NotNull
    public FirstPersonMode getFirstPersonMode(float tickDelta) {
        int i = this.layers.size();
        while (i > 0) {
            FirstPersonMode mode;
            Pair<Integer, IAnimation> layer;
            if (!(layer = this.layers.get(--i)).getRight().isActive() || (mode = layer.getRight().getFirstPersonMode(tickDelta)) == FirstPersonMode.NONE) continue;
            return mode;
        }
        return FirstPersonMode.NONE;
    }

    @Override
    @NotNull
    public FirstPersonConfiguration getFirstPersonConfiguration(float tickDelta) {
        int i = this.layers.size();
        while (i > 0) {
            FirstPersonMode mode;
            Pair<Integer, IAnimation> layer;
            if (!(layer = this.layers.get(--i)).getRight().isActive() || (mode = layer.getRight().getFirstPersonMode(tickDelta)) == FirstPersonMode.NONE) continue;
            return layer.getRight().getFirstPersonConfiguration(tickDelta);
        }
        return IAnimation.super.getFirstPersonConfiguration(tickDelta);
    }
}

