/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.handler;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Supplier;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_6396;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.GuiBookEntryList;
import vazkii.patchouli.common.book.Book;

public class BookCrashHandler
implements Supplier<String> {
    private static final String INDENT = "\n\t\t";
    private static final String LABEL = "Patchouli open book context";

    public static void appendToCrashReport(class_6396 report) {
        class_310 mc = class_310.method_1551();
        if (mc == null || !(mc.field_1755 instanceof GuiBook)) {
            return;
        }
        try {
            report.method_37123(LABEL, (Supplier)new BookCrashHandler());
        }
        catch (Exception e) {
            PatchouliAPI.LOGGER.fatal("Failed to extend crash report system info", (Throwable)e);
        }
    }

    @Override
    public String get() {
        class_437 screen = class_310.method_1551().field_1755;
        if (!(screen instanceof GuiBook)) {
            return "n/a";
        }
        GuiBook gui = (GuiBook)screen;
        Book book = gui.book;
        StringBuilder builder = new StringBuilder(INDENT);
        builder.append("Open book: ").append(book.id);
        if (gui instanceof GuiBookEntry) {
            GuiBookEntry entry = (GuiBookEntry)gui;
            builder.append(INDENT).append("Current entry: ").append(entry.getEntry().getId());
        } else if (gui instanceof GuiBookEntryList) {
            GuiBookEntryList list = (GuiBookEntryList)gui;
            builder.append(INDENT).append("Search query: ").append(list.getSearchQuery());
        }
        builder.append(INDENT).append("Current page spread: ").append(gui.getSpread());
        if (book.getContents().isErrored()) {
            Exception ex = book.getContents().getException();
            builder.append(INDENT).append("Book loading error: ");
            try (StringWriter sw = new StringWriter();
                 PrintWriter pw = new PrintWriter(sw);){
                ex.printStackTrace(pw);
                builder.append(sw.toString().replaceAll("\n", INDENT));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return builder.toString();
    }
}

