/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.oddion;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.potionstudios.biomeswevegone.client.BWGSounds;
import net.potionstudios.biomeswevegone.world.item.BWGItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Oddion
extends PathfinderMob
implements GeoEntity,
VariantHolder<Variant> {
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation WALKING = RawAnimation.begin().thenPlay("walking");
    private static final RawAnimation POP_UP = RawAnimation.begin().thenPlay("pop_up");
    private static final RawAnimation DANCE = RawAnimation.begin().thenPlay("dance");
    private static final RawAnimation GROUND = RawAnimation.begin().thenPlay("ground");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final RawAnimation PET = RawAnimation.begin().thenLoop("pet");
    private static final EntityDataAccessor<Integer> RISING_TIMER = SynchedEntityData.m_135353_(Oddion.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> GROUNDING_TIMER = SynchedEntityData.m_135353_(Oddion.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PET_TIMER = SynchedEntityData.m_135353_(Oddion.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.m_135353_(Oddion.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> PARTYING = SynchedEntityData.m_135353_(Oddion.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> GROUNDED = SynchedEntityData.m_135353_(Oddion.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int onionTime = 6000;
    public Goal movementGoal = new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0);
    @Nullable
    private BlockPos jukebox;

    public Oddion(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PARTYING, (Object)false);
        this.f_19804_.m_135372_(GROUNDED, (Object)true);
        this.f_19804_.m_135372_(RISING_TIMER, (Object)0);
        this.f_19804_.m_135372_(GROUNDING_TIMER, (Object)0);
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)0);
        this.f_19804_.m_135372_(PET_TIMER, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 2.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42499_}), false));
        super.m_8099_();
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant().getId());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(Variant.byId(compound.m_128451_("Variant")));
    }

    public static boolean checkOddionSpawnRules(EntityType<? extends Oddion> entity, LevelAccessor world, MobSpawnType spawnType, BlockPos pos, RandomSource rand) {
        return world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant(Variant.getSpawnVariant(level.m_213780_()));
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.4);
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return BWGSounds.ODDION_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return BWGSounds.ODDION_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return BWGSounds.ODDION_AMBIENT.get();
    }

    public void m_8107_() {
        if (!this.m_9236_().m_5776_()) {
            if (--this.onionTime <= 0) {
                this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.m_19998_((ItemLike)BWGItems.ODDION_BULB.get());
                this.m_146850_(GameEvent.f_157810_);
                this.onionTime = 6000;
            }
            if (!this.isGrounded()) {
                if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 3.46) || !this.m_9236_().m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
                    this.setPartying(false);
                    this.jukebox = null;
                }
                this.checkGoals();
                if (this.getRisingTime() > 0) {
                    this.setRisingTimer(this.getRisingTime() - 1);
                }
                if (this.m_9236_().m_45976_(Player.class, new AABB(this.m_20183_()).m_82400_(8.0)).isEmpty()) {
                    this.setGroundingTimer(this.getGroundingTime() + 1);
                }
            } else if (!this.m_9236_().m_45976_(Player.class, new AABB(this.m_20183_()).m_82400_(3.0)).isEmpty()) {
                this.setGrounded(false);
                this.setRisingTimer(20);
            }
            if (this.getGroundingTime() > 600) {
                this.setGrounded(true);
                this.f_21345_.m_25363_(this.movementGoal);
                this.setGroundingTimer(0);
            }
            if (this.isBeingPet()) {
                this.f_21345_.m_25363_(this.movementGoal);
                this.setPetTime(this.getPetTime() - 1);
            }
        }
        super.m_8107_();
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!this.isGrounded()) {
            this.petOddion();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void petOddion() {
        if (!this.m_9236_().f_46443_) {
            this.setPetTime(20);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), BWGSounds.ODDION_HAPPY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        float expansion = 0.5f;
        for (int heartCount = 0; heartCount < this.m_9236_().f_46441_.m_216339_(5, 10); ++heartCount) {
            double xSize = this.m_20191_().m_82362_();
            double ySize = this.m_20191_().m_82376_();
            double zSize = this.m_20191_().m_82385_();
            float randX = Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)((float)(-xSize) - expansion), (float)((float)xSize + expansion)) / 2.0f;
            float randY = Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)0.0f, (float)((float)ySize + expansion));
            float randZ = Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)((float)(-zSize) - expansion), (float)((float)zSize + expansion)) / 2.0f;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_() + (double)randX, this.m_20186_() + (double)randY, this.m_20189_() + (double)randZ, 0.05, 0.1, 0.05);
        }
    }

    public void checkGoals() {
        if (this.f_21345_.m_148105_().stream().noneMatch(goal -> goal.m_26015_().getClass() == WaterAvoidingRandomStrollGoal.class)) {
            this.f_21345_.m_25352_(1, this.movementGoal);
        }
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> event) {
        if (this.isGrounded()) {
            return event.setAndContinue(GROUND);
        }
        if (this.isRising()) {
            return event.setAndContinue(POP_UP);
        }
        if (this.isBeingPet()) {
            return event.setAndContinue(PET);
        }
        if (this.isPartying()) {
            return event.setAndContinue(DANCE);
        }
        if (event.isMoving()) {
            return event.setAndContinue(WALKING);
        }
        return event.setAndContinue(IDLE);
    }

    private boolean isRising() {
        return this.getRisingTime() > 0;
    }

    public void m_6818_(@NotNull BlockPos jukebox, boolean partying) {
        this.jukebox = jukebox;
        this.setPartying(partying);
        this.f_21345_.m_25363_(this.movementGoal);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public boolean isPartying() {
        return (Boolean)this.f_19804_.m_135370_(PARTYING);
    }

    public void setPartying(boolean flag) {
        this.f_19804_.m_135381_(PARTYING, (Object)flag);
    }

    public boolean isGrounded() {
        return (Boolean)this.f_19804_.m_135370_(GROUNDED);
    }

    public void setGrounded(boolean flag) {
        this.f_19804_.m_135381_(GROUNDED, (Object)flag);
    }

    public int getRisingTime() {
        return (Integer)this.f_19804_.m_135370_(RISING_TIMER);
    }

    public void setRisingTimer(int flag) {
        this.f_19804_.m_135381_(RISING_TIMER, (Object)flag);
    }

    public int getGroundingTime() {
        return (Integer)this.f_19804_.m_135370_(GROUNDING_TIMER);
    }

    public void setGroundingTimer(int flag) {
        this.f_19804_.m_135381_(GROUNDING_TIMER, (Object)flag);
    }

    public int getPetTime() {
        return (Integer)this.f_19804_.m_135370_(PET_TIMER);
    }

    public void setPetTime(int time) {
        this.f_19804_.m_135381_(PET_TIMER, (Object)time);
    }

    public boolean isBeingPet() {
        return this.getPetTime() > 0;
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)variant.getId());
    }

    @NotNull
    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT));
    }

    public static enum Variant implements StringRepresentable
    {
        STANDARD(0, "standard"),
        PINK(1, "pink"),
        ALBINO(2, "albino");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        private final String name;
        private final int id;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        private static Variant getSpawnVariant(RandomSource random) {
            int i = random.m_188503_(100);
            return i < 47 ? STANDARD : (i < 94 ? PINK : ALBINO);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

