/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.forge;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.potionstudios.biomeswevegone.world.entity.npc.BWGTradesConfig;
import net.potionstudios.biomeswevegone.world.entity.npc.BWGVillagerTrades;
import net.potionstudios.biomeswevegone.world.item.tools.ToolInteractions;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.BlockFeatures;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGBiomes;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.placed.BWGOverworldVegationPlacedFeatures;
import org.apache.logging.log4j.util.TriConsumer;

public class VanillaCompatForge {
    public static void init() {
        ToolInteractions.registerStrippableBlocks((block, stripped) -> {
            AxeItem.f_150683_ = new HashMap(AxeItem.f_150683_);
            AxeItem.f_150683_.put(block, stripped);
        });
        BlockFeatures.registerFlammable((TriConsumer<Block, Integer, Integer>)((TriConsumer)(arg_0, arg_1, arg_2) -> ((FireBlock)((FireBlock)Blocks.f_50083_)).m_53444_(arg_0, arg_1, arg_2)));
        BlockFeatures.registerCompostables((item, chance) -> ComposterBlock.m_51920_((float)chance.floatValue(), (ItemLike)item));
        ToolInteractions.registerFlattenables(ShovelItem.f_43110_::put);
    }

    public static void registerVanillaCompatEvents(IEventBus bus) {
        bus.addListener(VanillaCompatForge::registerTillables);
        bus.addListener(VanillaCompatForge::registerFuels);
        if (BWGTradesConfig.INSTANCE.get().enableTrades()) {
            bus.addListener(VanillaCompatForge::onVillagerTrade);
        }
        bus.addListener(VanillaCompatForge::onBoneMealUse);
    }

    private static void registerTillables(BlockEvent.BlockToolModificationEvent event) {
        if (event.getToolAction() == ToolActions.HOE_TILL && event.getLevel().m_8055_(event.getPos().m_7494_()).m_60795_()) {
            BlockState state = event.getState();
            if (state.m_60713_((Block)BWGBlocks.LUSH_GRASS_BLOCK.get()) || state.m_60713_(BWGBlocks.LUSH_DIRT.get())) {
                event.setFinalState(BWGBlocks.LUSH_FARMLAND.get().m_49966_());
            } else if (state.m_60713_(BWGBlocks.SANDY_DIRT.get())) {
                event.setFinalState(BWGBlocks.SANDY_FARMLAND.get().m_49966_());
            } else if (state.m_60713_(BWGBlocks.PEAT.get())) {
                event.setFinalState(Blocks.f_50093_.m_49966_());
            }
        }
    }

    private static void registerFuels(FurnaceFuelBurnTimeEvent event) {
        if (event.getItemStack().m_150930_(BWGBlocks.PEAT.get().m_5456_())) {
            event.setBurnTime(1200);
        }
    }

    private static void onVillagerTrade(VillagerTradesEvent event) {
        if (BWGVillagerTrades.TRADES.containsKey(event.getType())) {
            Int2ObjectMap trades = event.getTrades();
            BWGVillagerTrades.TRADES.get(event.getType()).forEach(pair -> ((List)trades.get(((Integer)pair.getFirst()).intValue())).add((trader, random) -> (MerchantOffer)pair.getSecond()));
        }
    }

    private static void onBoneMealUse(BonemealEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        if (event.getBlock().m_60713_(Blocks.f_50440_) && level.m_204166_(event.getPos()).m_203565_(BWGBiomes.PRAIRIE)) {
            BlockPos blockPos = event.getPos().m_7494_();
            BlockState blockState = BWGBlocks.PRAIRIE_GRASS.get().m_49966_();
            Optional optional = level.m_9598_().m_175515_(Registries.f_256988_).m_203636_(BWGOverworldVegationPlacedFeatures.PRAIRIE_GRASS_BONEMEAL);
            block0: for (int i = 0; i < 128; ++i) {
                Holder holder;
                BlockPos blockPos2 = blockPos;
                RandomSource random = level.m_213780_();
                for (int j = 0; j < i / 16; ++j) {
                    if (!level.m_8055_((blockPos2 = blockPos2.m_7918_(random.m_188503_(3) - 1, (random.m_188503_(3) - 1) * random.m_188503_(3) / 2, random.m_188503_(3) - 1)).m_7495_()).m_60713_(Blocks.f_50440_) || level.m_8055_(blockPos2).m_60838_((BlockGetter)level, blockPos2)) continue block0;
                }
                BlockState blockState2 = level.m_8055_(blockPos2);
                if (blockState2.m_60713_(blockState.m_60734_()) && random.m_188503_(10) == 0) {
                    ((BonemealableBlock)blockState.m_60734_()).m_214148_(level, random, blockPos2, blockState2);
                }
                if (!blockState2.m_60795_()) continue;
                if (random.m_188503_(8) == 0) {
                    List list = ((Biome)level.m_204166_(blockPos2).m_203334_()).m_47536_().m_47815_();
                    if (list.isEmpty()) continue;
                    holder = ((RandomPatchConfiguration)((ConfiguredFeature)list.get(0)).f_65378_()).f_191304_();
                } else {
                    if (!optional.isPresent()) continue;
                    holder = (Holder)optional.get();
                }
                ((PlacedFeature)holder.m_203334_()).m_226357_((WorldGenLevel)level, level.m_7726_().m_8481_(), random, blockPos2);
            }
            event.setResult(Event.Result.ALLOW);
        }
    }
}

