/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4595;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7752;
import net.minecraft.class_7755;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.world.entity.boats.BWGBoatEntity;
import net.potionstudios.biomeswevegone.world.entity.boats.BWGChestBoatEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class BWGBoatRenderer
extends class_897<class_1690> {
    private final Map<BWGBoatEntity.Type, Pair<class_2960, class_4595<class_1690>>> boatResources;

    public BWGBoatRenderer(class_5617.class_5618 context, boolean chestBoat) {
        super(context);
        this.field_4673 = 0.8f;
        this.boatResources = (Map)Stream.of(BWGBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)BiomesWeveGone.id(BWGBoatRenderer.getTextureLocation(type, chestBoat)), this.createBoatModel(context, (BWGBoatEntity.Type)((Object)type), chestBoat))));
    }

    public void render(class_1690 boat, float entityYaw, float partialTicks, class_4587 poseStack, @NotNull class_4597 buffer, int packedLight) {
        float f2;
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.375f, 0.0f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - entityYaw));
        float f = (float)boat.method_7533() - partialTicks;
        float f1 = boat.method_7554() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)f) * f * f1 / 10.0f * (float)boat.method_7543()));
        }
        if (!class_3532.method_15347((float)(f2 = boat.method_7547(partialTicks)), (float)0.0f)) {
            poseStack.method_22907(new Quaternionf().setAngleAxis(boat.method_7547(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<class_2960, class_4595<class_1690>> pair = this.getModelWithLocation(boat);
        class_2960 resourcelocation = (class_2960)pair.getFirst();
        class_4595 listmodel = (class_4595)pair.getSecond();
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        listmodel.method_2819((class_1297)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexconsumer = buffer.getBuffer(listmodel.method_23500(resourcelocation));
        listmodel.method_2828(poseStack, vertexconsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.method_5869()) {
            class_4588 vertexconsumer1 = buffer.getBuffer(class_1921.method_23589());
            if (listmodel instanceof class_7755) {
                class_7755 waterpatchmodel = (class_7755)listmodel;
                waterpatchmodel.method_22954().method_22698(poseStack, vertexconsumer1, packedLight, class_4608.field_21444);
            }
        }
        poseStack.method_22909();
        super.method_3936((class_1297)boat, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private static String getTextureLocation(BWGBoatEntity.Type pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    private class_4595<class_1690> createBoatModel(class_5617.class_5618 pContext, BWGBoatEntity.Type pType, boolean pChestBoat) {
        class_5601 modellayerlocation = pChestBoat ? BWGBoatRenderer.createChestBoatModelName(pType) : BWGBoatRenderer.createBoatModelName(pType);
        class_630 modelpart = pContext.method_32167(modellayerlocation);
        return pChestBoat ? new class_7752(modelpart) : new class_554(modelpart);
    }

    private static class_5601 createLocation(String pPath) {
        return new class_5601(BiomesWeveGone.id(pPath), "main");
    }

    public static class_5601 createBoatModelName(BWGBoatEntity.Type pType) {
        return BWGBoatRenderer.createLocation("boat/" + pType.getName());
    }

    public static class_5601 createChestBoatModelName(BWGBoatEntity.Type pType) {
        return BWGBoatRenderer.createLocation("chest_boat/" + pType.getName());
    }

    public Pair<class_2960, class_4595<class_1690>> getModelWithLocation(class_1690 boat) {
        if (boat instanceof BWGBoatEntity) {
            BWGBoatEntity boatEntity = (BWGBoatEntity)boat;
            return this.boatResources.get((Object)boatEntity.getModVariant());
        }
        if (boat instanceof BWGChestBoatEntity) {
            BWGChestBoatEntity chestBoatEntity = (BWGChestBoatEntity)boat;
            return this.boatResources.get((Object)chestBoatEntity.getModVariant());
        }
        return null;
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull class_1690 entity) {
        return (class_2960)this.getModelWithLocation(entity).getFirst();
    }
}

