/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul.mixin;

import com.glisco.numismaticoverhaul.ModComponents;
import com.glisco.numismaticoverhaul.block.ShopBlockEntity;
import com.glisco.numismaticoverhaul.block.ShopMerchant;
import com.glisco.numismaticoverhaul.currency.CurrencyComponent;
import com.glisco.numismaticoverhaul.currency.CurrencyHelper;
import com.glisco.numismaticoverhaul.item.CoinItem;
import com.glisco.numismaticoverhaul.item.NumismaticOverhaulItems;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1728;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1915;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1728.class})
public class MerchantScreenHandlerMixin {
    @Shadow
    @Final
    private class_1915 field_7863;

    @Inject(method={"autofill"}, at={@At(value="TAIL")})
    public void autofillOverride(int slot, class_1799 stack, CallbackInfo ci) {
        class_1728 handler = (class_1728)this;
        CurrencyComponent playerBalance = (CurrencyComponent)ModComponents.CURRENCY.get((Object)((class_1661)handler.method_7611((int)3).field_7871).field_7546);
        if (stack.method_7909() instanceof CoinItem) {
            MerchantScreenHandlerMixin.numismatic$autofillWithCoins(slot, stack, handler, playerBalance);
        } else if (stack.method_7909() == NumismaticOverhaulItems.MONEY_BAG) {
            MerchantScreenHandlerMixin.autofillWithMoneyBag(slot, stack, handler, playerBalance);
        }
        if (slot == 1) {
            playerBalance.commitTransactions();
        }
    }

    private static void numismatic$autofillWithCoins(int slot, class_1799 stack, class_1728 handler, CurrencyComponent playerBalance) {
        long presentCurrency;
        long requiredCurrency = ((CoinItem)stack.method_7909()).currency.getRawValue(stack.method_7947());
        if (requiredCurrency <= (presentCurrency = ((CoinItem)stack.method_7909()).currency.getRawValue(handler.method_7611(slot).method_7677().method_7947()))) {
            return;
        }
        long neededCurrency = requiredCurrency - presentCurrency;
        if (neededCurrency > playerBalance.getValue()) {
            return;
        }
        playerBalance.pushTransaction(-neededCurrency);
        ((class_1735)handler.field_7761.get(slot)).method_48931(stack.method_7972());
    }

    private static void autofillWithMoneyBag(int slot, class_1799 stack, class_1728 handler, CurrencyComponent playerBalance) {
        long availableCurrencyInPlayerInventory;
        if (class_1799.method_31577((class_1799)stack, (class_1799)handler.method_7611(slot).method_7677())) {
            return;
        }
        class_1657 player = ((class_1661)handler.method_7611((int)3).field_7871).field_7546;
        long requiredCurrency = NumismaticOverhaulItems.MONEY_BAG.getValue(stack);
        long neededCurrency = requiredCurrency - (availableCurrencyInPlayerInventory = CurrencyHelper.getMoneyInInventory(player, false));
        if (neededCurrency > playerBalance.getValue()) {
            return;
        }
        if (neededCurrency <= 0L) {
            CurrencyHelper.deductFromInventory(player, requiredCurrency);
        } else {
            CurrencyHelper.deductFromInventory(player, availableCurrencyInPlayerInventory);
            playerBalance.pushTransaction(-neededCurrency);
        }
        ((class_1735)handler.field_7761.get(slot)).method_48931(stack.method_7972());
    }

    @Inject(method={"playYesSound"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkForEntityOnYes(CallbackInfo ci) {
        if (!(this.field_7863 instanceof class_1297)) {
            ci.cancel();
        }
    }

    @Inject(method={"canUse"}, at={@At(value="HEAD")}, cancellable=true)
    public void thwartTaxEvasion(class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        class_1915 class_19152 = this.field_7863;
        if (!(class_19152 instanceof ShopMerchant)) {
            return;
        }
        ShopMerchant shopMerchant = (ShopMerchant)class_19152;
        ShopBlockEntity shop = shopMerchant.shop();
        if (shop.method_10997().method_8321(shop.method_11016()) != shop || shop.method_11016().method_40081(player.method_23317(), player.method_23318(), player.method_23321()) > 100.0) {
            cir.setReturnValue((Object)false);
        }
    }
}

