/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul.client.gui;

import com.glisco.numismaticoverhaul.NumismaticOverhaul;
import com.glisco.numismaticoverhaul.block.ShopOffer;
import com.glisco.numismaticoverhaul.block.ShopScreenHandler;
import com.glisco.numismaticoverhaul.currency.CurrencyResolver;
import com.glisco.numismaticoverhaul.network.UpdateShopScreenS2CPacket;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.ui.base.BaseUIModelHandledScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.UISounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_7923;

public class ShopScreen
extends BaseUIModelHandledScreen<FlowLayout, ShopScreenHandler> {
    public static final class_2960 TEXTURE = NumismaticOverhaul.id("textures/gui/shop_gui.png");
    public static final class_2960 TRADES_TEXTURE = NumismaticOverhaul.id("textures/gui/shop_gui_trades.png");
    private final List<class_4185> tabButtons = new ArrayList<class_4185>();
    private final List<ShopOffer> offers = new ArrayList<ShopOffer>();
    private Runnable afterDataUpdate = () -> {};
    private Consumer<String> priceDisplay = s -> {};
    private int tab = 0;

    public ShopScreen(ShopScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title, FlowLayout.class, NumismaticOverhaul.id("shop"));
        ++this.field_25270;
        this.field_25268 = 5;
    }

    protected void build(FlowLayout rootComponent) {
        this.tabButtons.clear();
        FlowLayout leftColumn = (FlowLayout)rootComponent.childById(FlowLayout.class, "left-column");
        leftColumn.child((Component)this.makeTabButton(class_1802.field_8106, false, button -> this.selectTab(0)));
        leftColumn.child((Component)this.makeTabButton(class_1802.field_8687, true, button -> this.selectTab(1)));
        ((ButtonComponent)rootComponent.childById(ButtonComponent.class, "extract-button")).onPress(button -> ((ShopScreenHandler)this.field_2797).extractCurrency());
        ((FlowLayout)rootComponent.childById(FlowLayout.class, "transfer-button")).mouseDown().subscribe((x, y, button) -> {
            if (button != 0) {
                return false;
            }
            ((ShopScreenHandler)this.field_2797).toggleTransfer();
            UISounds.playInteractionSound();
            return true;
        });
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top, int button) {
        ItemComponent buffer = (ItemComponent)this.component(ItemComponent.class, "trade-buffer");
        if (buffer != null && buffer.isInBoundingBox(mouseX, mouseY)) {
            return false;
        }
        return super.method_2381(mouseX, mouseY, left, top, button);
    }

    public void update(UpdateShopScreenS2CPacket data) {
        if (this.uiAdapter == null) {
            return;
        }
        long[] storedCurrency = CurrencyResolver.splitValues(data.storedCurrency());
        ((LabelComponent)this.component(LabelComponent.class, "bronze-count")).text((class_2561)class_2561.method_43470((String)String.valueOf(storedCurrency[0])));
        ((LabelComponent)this.component(LabelComponent.class, "silver-count")).text((class_2561)class_2561.method_43470((String)String.valueOf(storedCurrency[1])));
        ((LabelComponent)this.component(LabelComponent.class, "gold-count")).text((class_2561)class_2561.method_43470((String)String.valueOf(storedCurrency[2])));
        int prevOffers = this.offers.size();
        this.offers.clear();
        this.offers.addAll(data.offers());
        this.populateTrades(this.tab);
        if (this.tab == 1 && this.offers.size() > prevOffers) {
            ScrollContainer offersScroll = (ScrollContainer)this.component(ScrollContainer.class, "offer-container");
            FlowLayout leftColumn = (FlowLayout)offersScroll.childById(FlowLayout.class, "first-trades-column");
            offersScroll.scrollTo((Component)leftColumn.children().get(leftColumn.children().size() - 1));
        }
        ((FlowLayout)this.component(FlowLayout.class, "transfer-button")).tooltip((class_2561)(data.transferEnabled() ? class_2561.method_43471((String)"gui.numismatic-overhaul.shop.transfer_tooltip.enabled") : class_2561.method_43471((String)"gui.numismatic-overhaul.shop.transfer_tooltip.disabled")));
        ((LabelComponent)this.component(LabelComponent.class, "transfer-label")).text((class_2561)(data.transferEnabled() ? TextOps.withColor((String)"\u2714", (int)2686911) : TextOps.withColor((String)"\u2718", (int)15408438)));
        this.afterDataUpdate();
    }

    public void afterDataUpdate() {
        this.afterDataUpdate.run();
    }

    private void selectTab(int index) {
        if (this.tab == index) {
            return;
        }
        if (index == 0) {
            this.swapBackgroundTexture(TEXTURE);
            this.field_25268 = 5;
            ((FlowLayout)this.component(FlowLayout.class, "right-column")).removeChild(this.component(FlowLayout.class, "trade-edit-widget"));
            this.afterDataUpdate = () -> {};
            this.priceDisplay = s -> {};
        } else {
            this.swapBackgroundTexture(TRADES_TEXTURE);
            this.field_25268 = 69420;
            FlowLayout editWidget = (FlowLayout)this.model.expandTemplate(FlowLayout.class, "trade-edit-widget", Map.of());
            ButtonComponent submitButton = (ButtonComponent)editWidget.childById(ButtonComponent.class, "submit-button");
            ButtonComponent deleteButton = (ButtonComponent)editWidget.childById(ButtonComponent.class, "delete-button");
            ItemComponent tradeBuffer = (ItemComponent)editWidget.childById(ItemComponent.class, "trade-buffer");
            tradeBuffer.showOverlay(true);
            tradeBuffer.mouseDown().subscribe((mouseX, mouseY, button) -> {
                ((ShopScreenHandler)this.field_2797).handleBufferClick();
                return true;
            });
            class_342 priceField = (class_342)editWidget.childById(class_342.class, "price-field");
            priceField.method_1880(7);
            priceField.method_1890(s -> s.matches("\\d*"));
            priceField.method_1863(s -> {
                this.afterDataUpdate();
                long[] price = CurrencyResolver.splitValues(s.isBlank() ? 0L : (long)Integer.parseInt(s));
                ((LabelComponent)this.component(LabelComponent.class, "offer-bronze-count")).text((class_2561)class_2561.method_43470((String)String.valueOf(price[0])));
                ((LabelComponent)this.component(LabelComponent.class, "offer-silver-count")).text((class_2561)class_2561.method_43470((String)String.valueOf(price[1])));
                ((LabelComponent)this.component(LabelComponent.class, "offer-gold-count")).text((class_2561)class_2561.method_43470((String)String.valueOf(price[2])));
            });
            submitButton.onPress(button -> ((ShopScreenHandler)this.field_2797).createOffer(Integer.parseInt(priceField.method_1882())));
            deleteButton.onPress(button -> ((ShopScreenHandler)this.field_2797).deleteOffer());
            this.priceDisplay = arg_0 -> ((class_342)priceField).method_1852(arg_0);
            this.afterDataUpdate = () -> {
                String priceText = priceField.method_1882();
                class_1799 bufferStack = ((ShopScreenHandler)this.field_2797).getBufferStack();
                boolean hasOffer = this.hasOfferFor(bufferStack);
                submitButton.field_22763 = !priceText.isBlank() && Integer.parseInt(priceText) > 0 && !bufferStack.method_7960() && (this.offers.size() < 24 || hasOffer);
                deleteButton.field_22763 = hasOffer;
                tradeBuffer.stack(bufferStack);
                if (!bufferStack.method_7960()) {
                    ArrayList tooltip = new ArrayList();
                    bufferStack.method_7950((class_1657)this.field_22787.field_1724, (class_1836)(this.field_22787.field_1690.field_1827 ? class_1836.field_41071 : class_1836.field_41070)).stream().map(class_2561::method_30937).map(class_5684::method_32662).forEach(tooltip::add);
                    bufferStack.method_32347().ifPresent(data -> {
                        class_5684 fabricComponent = ((TooltipComponentCallback)TooltipComponentCallback.EVENT.invoker()).getComponent(data);
                        tooltip.add(1, Objects.requireNonNullElseGet(fabricComponent, () -> class_5684.method_32663((class_5632)data)));
                    });
                    tradeBuffer.tooltip(tooltip);
                } else {
                    tradeBuffer.tooltip((List)null);
                }
            };
            ((FlowLayout)this.component(FlowLayout.class, "right-column")).child(0, (Component)editWidget);
        }
        this.populateTrades(index);
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            this.tabButtons.get((int)i).field_22763 = i != index;
        }
        this.tab = index;
    }

    private boolean hasOfferFor(class_1799 stack) {
        return this.offers.stream().anyMatch(offer -> class_1799.method_7973((class_1799)stack, (class_1799)offer.getSellStack()));
    }

    private void populateTrades(int tab) {
        FlowLayout firstColumn = (FlowLayout)this.component(FlowLayout.class, "first-trades-column");
        FlowLayout secondColumn = (FlowLayout)this.component(FlowLayout.class, "second-trades-column");
        firstColumn.clearChildren();
        secondColumn.clearChildren();
        if (tab == 0) {
            return;
        }
        for (int i = 0; i < this.offers.size(); ++i) {
            int offerIndex = i;
            ShopOffer offer = this.offers.get(offerIndex);
            FlowLayout component = (FlowLayout)this.model.expandTemplate(FlowLayout.class, "trade-button", Map.of("price", String.valueOf(offer.getPrice())));
            ((ItemComponent)component.childById(ItemComponent.class, "item-display")).stack(offer.getSellStack());
            ((ButtonComponent)component.childById(ButtonComponent.class, "trade-button")).onPress(button -> {
                ((ShopScreenHandler)this.field_2797).loadOffer(offerIndex);
                this.priceDisplay.accept(String.valueOf(offer.getPrice()));
            });
            (i % 2 == 0 ? firstColumn : secondColumn).child((Component)component);
        }
    }

    private void swapBackgroundTexture(class_2960 newTexture) {
        FlowLayout background = (FlowLayout)this.component(FlowLayout.class, "background");
        background.removeChild((Component)background.children().get(0));
        background.child(0, this.model.expandTemplate(TextureComponent.class, "background-texture", Map.of("texture", newTexture.toString())));
    }

    private FlowLayout makeTabButton(class_1792 icon, boolean active, Consumer<ButtonComponent> onPress) {
        FlowLayout buttonContainer = (FlowLayout)this.model.expandTemplate(FlowLayout.class, "tab-button", Map.of("icon-item", class_7923.field_41178.method_10221((Object)icon).toString()));
        ButtonComponent button = (ButtonComponent)buttonContainer.childById(ButtonComponent.class, "tab-button");
        this.tabButtons.add((class_4185)button);
        button.field_22763 = active;
        button.onPress(onPress);
        return buttonContainer;
    }

    public int tab() {
        return this.tab;
    }

    static {
        UIParsing.registerFactory((String)"numismatic.fake-slot", element -> new FakeSlotComponent(class_1799.field_8037));
    }

    public static class FakeSlotComponent
    extends ItemComponent {
        protected FakeSlotComponent(class_1799 stack) {
            super(stack);
        }

        public boolean shouldDrawTooltip(double mouseX, double mouseY) {
            class_1703 screenHandler = class_310.method_1551().field_1724.field_7512;
            return (screenHandler == null || screenHandler.method_34255().method_7960()) && super.shouldDrawTooltip(mouseX, mouseY);
        }
    }
}

