/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.textures;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.textures.ImageTransformer;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.minecraft.client.resources.metadata.animation.AnimationFrame;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.block.Rotation;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class TextureImage
implements AutoCloseable {
    @Nullable
    private final AnimationMetadataSection metadata;
    private final NativeImage image;
    private final FrameSize frameSize;
    private final int frameCount;
    private final int frameScale;

    private TextureImage(NativeImage image, @Nullable AnimationMetadataSection metadata) {
        this.image = image;
        this.metadata = metadata;
        int imgWidth = this.imageWidth();
        int imgHeight = this.imageHeight();
        this.frameSize = metadata == null ? new FrameSize(imgWidth, imgHeight) : metadata.m_245821_(imgWidth, imgHeight);
        this.frameScale = imgWidth / this.frameSize.f_244129_();
        int frameScaleHeight = imgHeight / this.frameSize.f_244503_();
        this.frameCount = this.frameScale * frameScaleHeight;
    }

    public void forEachFramePixel(FramePixelConsumer framePixelConsumer) {
        for (int ind = 0; ind < this.frameCount; ++ind) {
            int xOff = this.getFrameStartX(ind);
            int yOff = this.getFrameStartY(ind);
            for (int x = 0; x < this.frameWidth(); ++x) {
                for (int y = 0; y < this.frameHeight(); ++y) {
                    framePixelConsumer.accept(ind, x + xOff, y + yOff);
                }
            }
        }
    }

    @Deprecated(forRemoval=true)
    public void forEachFrame(FramePixelConsumer e) {
        this.forEachFramePixel(e);
    }

    public void toGrayscale() {
        SpriteUtils.grayscaleImage(this.image);
    }

    public RGBColor getAverageColor() {
        return SpriteUtils.averageColor(this.image);
    }

    public int frameWidth() {
        return this.frameSize.f_244129_();
    }

    public int frameHeight() {
        return this.frameSize.f_244503_();
    }

    public int getFrameStartX(int frameIndex) {
        return frameIndex % this.frameScale * this.frameWidth();
    }

    public int getFrameStartY(int frameIndex) {
        return frameIndex / this.frameScale * this.frameHeight();
    }

    public int getFramePixel(int frameIndex, int x, int y) {
        return this.image.m_84985_(this.getFrameStartX(frameIndex) + x, this.getFrameStartY(frameIndex) + y);
    }

    public void setFramePixel(int frameIndex, int x, int y, int color) {
        this.image.m_84988_(this.getFrameStartX(frameIndex) + x, this.getFrameStartY(frameIndex) + y, color);
    }

    public NativeImage getImage() {
        return this.image;
    }

    public int frameCount() {
        return this.frameCount;
    }

    @Nullable
    public AnimationMetadataSection getMetadata() {
        return this.metadata;
    }

    public TextureImage makeCopy() {
        NativeImage im = new NativeImage(this.imageWidth(), this.imageHeight(), false);
        im.m_85054_(this.image);
        return new TextureImage(im, this.metadata);
    }

    public TextureImage createAnimationTemplate(int length, AnimationMetadataSection useDataFrom) {
        ArrayList<AnimationFrame> frameData = new ArrayList<AnimationFrame>();
        useDataFrom.m_174861_((i, t) -> frameData.add(new AnimationFrame(i, t)));
        return this.createAnimationTemplate(length, frameData, useDataFrom.m_119030_(), useDataFrom.m_119036_());
    }

    public TextureImage createAnimationTemplate(int length, List<AnimationFrame> frameData, int frameTime, boolean interpolate) {
        NativeImage im = new NativeImage(this.frameWidth(), this.frameHeight() * length, false);
        TextureImage t = new TextureImage(im, new AnimationMetadataSection(frameData, this.frameWidth(), this.frameHeight(), frameTime, interpolate));
        t.forEachFramePixel((i, x, y) -> {
            int xo = this.getFrameX(i, x);
            int yo = this.getFrameY(i, y);
            t.image.m_84988_(x.intValue(), y.intValue(), this.image.m_84985_(xo, yo));
        });
        return t;
    }

    public static TextureImage open(ResourceManager manager, ResourceLocation relativePath) throws IOException {
        try {
            ResourceLocation textureLoc = ResType.TEXTURES.getPath(relativePath);
            NativeImage i = SpriteUtils.readImage(manager, textureLoc);
            ResourceLocation metadataLoc = ResType.MCMETA.getPath(relativePath);
            AnimationMetadataSection metadata = null;
            Optional res = manager.m_213713_(metadataLoc);
            if (res.isPresent()) {
                try (InputStream metadataStream = ((Resource)res.get()).m_215507_();){
                    metadata = (AnimationMetadataSection)AbstractPackResources.m_10214_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_, (InputStream)metadataStream);
                }
                catch (Exception ignored) {
                    throw new IOException("Failed to open mcmeta file at location " + String.valueOf(metadataLoc));
                }
            }
            return new TextureImage(i, metadata);
        }
        catch (Exception e) {
            throw new IOException("Failed to open texture at location " + String.valueOf(relativePath) + ": no such file");
        }
    }

    public static TextureImage createNew(int width, int height, @Nullable AnimationMetadataSection animation) {
        TextureImage v = new TextureImage(new NativeImage(width, height, false), animation);
        v.clear();
        return v;
    }

    public static TextureImage createMask(TextureImage original, Palette palette) {
        TextureImage copy = original.makeCopy();
        NativeImage nativeImage = copy.getImage();
        SpriteUtils.forEachPixel(nativeImage, (x, y) -> {
            int color = nativeImage.m_84985_(x.intValue(), y.intValue());
            if (palette.hasColor(color)) {
                nativeImage.m_84988_(x.intValue(), y.intValue(), 0);
            } else {
                nativeImage.m_84988_(x.intValue(), y.intValue(), -16777216);
            }
        });
        return copy;
    }

    public TextureImage createResized(float widthScale, float heightScale) {
        int newW = (int)((float)this.imageWidth() * widthScale);
        int newH = (int)((float)this.imageHeight() * heightScale);
        AnimationMetadataSection meta = null;
        if (this.metadata != null) {
            int mW = (int)((float)this.metadata.f_119014_ * widthScale);
            int mH = (int)((float)this.metadata.f_119015_ * heightScale);
            meta = new AnimationMetadataSection(this.metadata.f_119013_, mW, mH, this.metadata.m_119030_(), this.metadata.m_119036_());
        }
        TextureImage im = TextureImage.createNew(newW, newH, meta);
        ImageTransformer t = ImageTransformer.builder(this.frameWidth(), this.frameHeight(), im.frameWidth(), im.frameHeight()).copyRect(0, 0, this.frameWidth(), this.frameHeight(), 0, 0).build();
        t.apply(this, im);
        return im;
    }

    public void clear() {
        this.image.m_84997_(0, 0, this.image.m_84982_(), this.image.m_85084_(), 0);
    }

    public static TextureImage of(NativeImage image, @Nullable AnimationMetadataSection animation) {
        return new TextureImage(image, animation);
    }

    @Override
    public void close() {
        this.image.close();
    }

    public int imageWidth() {
        return this.image.m_84982_();
    }

    public int imageHeight() {
        return this.image.m_85084_();
    }

    public ImmutableList<NativeImage> splitFrames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.metadata == null) {
            builder.add((Object)this.image);
            return builder.build();
        }
        int imgWidth = this.imageWidth();
        int imgHeight = this.imageHeight();
        FrameSize fs = this.metadata.m_245821_(imgWidth, imgHeight);
        int frameScaleWidth = imgWidth / fs.f_244129_();
        int frameScaleHeight = imgHeight / fs.f_244503_();
        int maxFrames = frameScaleWidth * frameScaleHeight;
        ArrayList indexList = Lists.newArrayList();
        this.metadata.m_174861_((index, time) -> indexList.add(index));
        if (indexList.isEmpty()) {
            for (int l = 0; l < maxFrames; ++l) {
                indexList.add(l);
            }
        }
        if (indexList.size() <= 1) {
            builder.add((Object)this.image);
        } else {
            Iterator iterator = indexList.iterator();
            while (iterator.hasNext()) {
                int index2 = (Integer)iterator.next();
                int xOffset = index2 % frameScaleWidth * this.frameWidth();
                int yOffset = index2 / frameScaleWidth * this.frameHeight();
                if (index2 < 0 || xOffset + this.frameWidth() >= imgWidth || yOffset + this.frameHeight() >= imgHeight) continue;
                NativeImage f = new NativeImage(this.frameWidth(), this.frameHeight(), false);
                for (int x = 0; x < this.frameWidth(); ++x) {
                    for (int y = 0; y < this.frameHeight(); ++y) {
                        f.m_84988_(x, y, this.image.m_84985_(x + xOffset, y + yOffset));
                    }
                }
                builder.add((Object)f);
            }
        }
        return builder.build();
    }

    @Nullable
    public JsonObject serializeMcMeta() {
        if (this.metadata == null) {
            return null;
        }
        JsonObject obj = new JsonObject();
        JsonObject animation = new JsonObject();
        animation.addProperty("frametime", (Number)this.metadata.m_119030_());
        animation.addProperty("interpolate", Boolean.valueOf(this.metadata.m_119036_()));
        animation.addProperty("height", (Number)this.frameSize.f_244503_());
        animation.addProperty("width", (Number)this.frameSize.f_244129_());
        JsonArray frames = new JsonArray();
        this.metadata.m_174861_((i, t) -> {
            if (t != -1) {
                JsonObject o = new JsonObject();
                o.addProperty("time", (Number)t);
                o.addProperty("index", (Number)i);
                frames.add((JsonElement)o);
            } else {
                frames.add((Number)i);
            }
        });
        animation.add("frames", (JsonElement)frames);
        obj.add("animation", (JsonElement)animation);
        return obj;
    }

    private void applyOverlay(boolean onlyOnExisting, TextureImage ... overlays) throws IllegalStateException {
        for (TextureImage o : overlays) {
            if (o.frameWidth() < this.frameWidth()) {
                throw new IllegalStateException("Could not apply overlay onto images because overlay was too small (overlay W: " + o.frameWidth() + ", image W: " + this.frameWidth());
            }
            if (o.frameHeight() >= this.frameHeight()) continue;
            throw new IllegalStateException("Could not apply overlay onto images because overlay was too small (overlay H: " + o.frameHeight() + ", image H: " + this.frameHeight());
        }
        for (TextureImage o : overlays) {
            this.forEachFramePixel((frameIndex, globalX, globalY) -> {
                int frameX = this.getFrameX(frameIndex, globalX);
                int frameY = this.getFrameY(frameIndex, globalY);
                int targetOverlayFrame = Math.min(frameIndex, o.frameCount - 1);
                int overlayPixel = o.getFramePixel(targetOverlayFrame, frameX, frameY);
                if (onlyOnExisting && FastColor.ABGR32.m_266503_((int)overlayPixel) == 0) {
                    return;
                }
                this.image.m_166411_(globalX.intValue(), globalY.intValue(), overlayPixel);
            });
            o.close();
        }
    }

    private int getFrameY(Integer frameIndex, Integer globalY) {
        return globalY - this.getFrameStartY(frameIndex);
    }

    private int getFrameX(Integer frameIndex, Integer globalX) {
        return globalX - this.getFrameStartX(frameIndex);
    }

    public void applyOverlay(TextureImage ... overlays) throws IllegalStateException {
        this.applyOverlay(false, overlays);
    }

    public void applyOverlayOnExisting(TextureImage ... overlays) throws IllegalStateException {
        this.applyOverlay(true, overlays);
    }

    public void removeAlpha(int backgroundColor) {
        for (int x = 0; x < this.image.m_84982_(); ++x) {
            for (int y = 0; y < this.image.m_85084_(); ++y) {
                int oldValue = this.image.m_84985_(x, y);
                int a = FastColor.ABGR32.m_266503_((int)oldValue);
                if (a == 0) {
                    this.image.m_84988_(x, y, backgroundColor);
                    continue;
                }
                this.image.m_84988_(x, y, FastColor.ABGR32.m_266248_((int)255, (int)FastColor.ABGR32.m_266247_((int)oldValue), (int)FastColor.ABGR32.m_266446_((int)oldValue), (int)FastColor.ABGR32.m_266313_((int)oldValue)));
            }
        }
    }

    public void crop(TextureImage mask) {
        this.crop(mask, true);
    }

    public void crop(TextureImage mask, boolean discardInner) {
        int width = this.imageWidth();
        int height = this.imageHeight();
        if (mask.imageHeight() < height || mask.imageWidth() < width) {
            throw new IllegalStateException("Could not merge images because they had different dimensions");
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (FastColor.ABGR32.m_266503_((int)mask.image.m_84985_(x, y)) != 0 != discardInner) continue;
                this.image.m_84988_(x, y, 0);
            }
        }
        mask.close();
    }

    public TextureImage createRotated(Rotation rotation) {
        TextureImage flippedImage = TextureImage.createNew(this.frameHeight(), this.frameWidth() * this.frameCount, this.metadata);
        this.forEachFramePixel((frameIndex, globalX, globalY) -> {
            int frameX = this.getFrameX(frameIndex, globalX);
            int frameY = this.getFrameY(frameIndex, globalY);
            int newFrameX = frameX;
            int newFrameY = frameY;
            int frameWidth = this.frameWidth();
            int frameHeight = this.frameHeight();
            if (rotation == Rotation.CLOCKWISE_90) {
                newFrameX = frameHeight - frameY - 1;
                newFrameY = frameX;
            } else if (rotation == Rotation.CLOCKWISE_180) {
                newFrameX = frameWidth - frameX - 1;
                newFrameY = frameHeight - frameY - 1;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                newFrameX = frameY;
                newFrameY = frameWidth - frameX - 1;
            }
            int newGlobalX = flippedImage.getFrameStartX(frameIndex) + newFrameX;
            int newGlobalY = flippedImage.getFrameStartY(frameIndex) + newFrameY;
            int pixel = this.getImage().m_84985_(globalX.intValue(), globalY.intValue());
            flippedImage.getImage().m_84988_(newGlobalX, newGlobalY, pixel);
        });
        return flippedImage;
    }

    @FunctionalInterface
    public static interface FramePixelConsumer
    extends TriConsumer<Integer, Integer, Integer> {
        public void accept(Integer var1, Integer var2, Integer var3);
    }
}

