var Opcodes = Java.type('org.objectweb.asm.Opcodes');
var InsnNode = Java.type('org.objectweb.asm.tree.InsnNode');
var VarInsnNode = Java.type('org.objectweb.asm.tree.VarInsnNode');
var MethodInsnNode = Java.type('org.objectweb.asm.tree.MethodInsnNode');
var FieldInsnNode = Java.type('org.objectweb.asm.tree.FieldInsnNode');
var JumpInsnNode = Java.type('org.objectweb.asm.tree.JumpInsnNode');
var LabelNode = Java.type('org.objectweb.asm.tree.LabelNode');

var ASMAPI = Java.type('net.minecraftforge.coremod.api.ASMAPI');

function initializeCoreMod() {
	return {
		'putQuadData': {
			'target': {
				'type': 'METHOD',
				'class': 'net.minecraft.client.renderer.block.ModelBlockRenderer',
				'methodName': 'm_111023_',
				'methodDesc': '(Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lnet/minecraft/client/renderer/block/model/BakedQuad;FFFFIIIII)V'
			},
			'transformer': putQuadData
		}
	}	
}

function putQuadData(method) {
	var instructions = method.instructions;
	var insn = instructions.get(0);

	// 11 - 14
	for (var index = 11; index <= 14; index++)
	{
		instructions.insertBefore(insn, new VarInsnNode(Opcodes.ILOAD, index));
		instructions.insertBefore(insn, new VarInsnNode(Opcodes.ALOAD, 6));
		instructions.insertBefore(insn, new MethodInsnNode(Opcodes.INVOKESTATIC, 'com/legacy/lucent/core/asm_hooks/ModelBlockRendererHooks', 'getBrightness', '(ILnet/minecraft/client/renderer/block/model/BakedQuad;)I'));
		instructions.insertBefore(insn, new VarInsnNode(Opcodes.ISTORE, index));
	}

	ASMAPI.log('INFO', '[Lucent] Transformed ModelBlockRenderer.putQuadData');

	return method;
}
