/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.core.reflection;

import com.legacy.lucent.core.LucentMod;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public record ReflectedField<T>(Lazy<Optional<Field>> field, String fieldName, Class<T> fieldClass, Supplier<T> defaultRet) {
    public static <T> ReflectedField<T> of(Supplier<Optional<Class<?>>> ownerClass, String fieldName, Class<T> fieldClass, Supplier<T> defaultRet) {
        return new ReflectedField<T>((Lazy<Optional<Field>>)Lazy.of(() -> {
            Optional opClass = (Optional)ownerClass.get();
            if (opClass.isPresent()) {
                try {
                    return Optional.ofNullable(ObfuscationReflectionHelper.findField((Class)((Class)opClass.get()), (String)fieldName));
                }
                catch (Throwable e) {
                    LucentMod.LOGGER.printStacktrace("Failed to reflect a field. Class: " + opClass.get() + ", Field: " + fieldName, e);
                }
            } else {
                LucentMod.LOGGER.error("Couldn't obtain reflected class for field: " + fieldName, new Object[0]);
            }
            return Optional.empty();
        }), fieldName, fieldClass, defaultRet);
    }

    public T get(@Nullable Object obj) {
        try {
            Object ret;
            Optional f = (Optional)this.field.get();
            if (f.isPresent() && this.fieldClass.isInstance(ret = ((Field)f.get()).get(obj))) {
                return (T)ret;
            }
        }
        catch (Throwable t) {
            LucentMod.LOGGER.printStacktrace("Failed to get a reflected value for " + this.fieldClass.getName() + "." + this.fieldName, t);
        }
        return this.defaultRet.get();
    }
}

