/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.core.reflection;

import com.legacy.lucent.core.LucentMod;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraftforge.common.util.Lazy;

public record ReflectedClass(Lazy<Optional<Class<?>>> clazz) implements Supplier<Optional<Class<?>>>
{
    public static ReflectedClass of(String classPath) {
        return new ReflectedClass(() -> {
            try {
                return Optional.ofNullable(Class.forName(classPath));
            }
            catch (ClassNotFoundException e) {
                LucentMod.LOGGER.printStacktrace("Failed to reflect a class. Class: " + classPath, e);
                return Optional.empty();
            }
        });
    }

    @Override
    public Optional<Class<?>> get() {
        return (Optional)this.clazz.get();
    }

    public boolean isInstance(Object obj) {
        Object opClass = this.get();
        return ((Optional)opClass).isPresent() && ((Class)((Optional)opClass).get()).isInstance(obj);
    }
}

