/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.StringReader;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.bindings.event.BlockEvents;
import dev.latvian.mods.kubejs.bindings.event.ItemEvents;
import dev.latvian.mods.kubejs.block.BlockModificationEventJS;
import dev.latvian.mods.kubejs.item.ItemModificationEventJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.platform.MiscPlatformHelper;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.JSObjectType;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.TickDuration;
import dev.latvian.mods.kubejs.util.WrappedJS;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.mod.util.Copyable;
import dev.latvian.mods.rhino.mod.util.MinecraftRemapper;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import dev.latvian.mods.rhino.mod.util.RemappingHelper;
import dev.latvian.mods.rhino.mod.util.color.Color;
import dev.latvian.mods.rhino.mod.util.color.SimpleColorWithAlpha;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_1310;
import net.minecraft.class_1311;
import net.minecraft.class_151;
import net.minecraft.class_173;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2096;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2300;
import net.minecraft.class_2303;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2491;
import net.minecraft.class_2509;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_40;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5270;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_60;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6334;
import net.minecraft.class_6728;
import net.minecraft.class_8567;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class UtilsJS {
    public static final Random RANDOM = new Random();
    public static final Pattern REGEX_PATTERN = Pattern.compile("/(.*)/([a-z]*)");
    public static final class_2960 AIR_LOCATION = new class_2960("minecraft:air");
    public static final Pattern SNAKE_CASE_SPLIT = Pattern.compile("[:_/]");
    public static final Set<String> ALWAYS_LOWER_CASE = new HashSet<String>(Arrays.asList("a", "an", "the", "of", "on", "in", "and", "or", "but", "for"));
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static MinecraftServer staticServer = null;
    public static class_5455 staticRegistryAccess = class_5455.field_40585;
    public static final class_2960 UNKNOWN_ID = new class_2960("unknown", "unknown");
    public static final Predicate<Object> ALWAYS_TRUE = o -> true;
    public static final Pattern TEMPORAL_AMOUNT_PATTERN = Pattern.compile("(\\d+)\\s*(y|M|d|w|h|m|s|ms|ns|t)\\b?");
    private static Collection<class_2680> ALL_STATE_CACHE = null;
    private static final Map<String, class_2300> ENTITY_SELECTOR_CACHE = new HashMap<String, class_2300>();
    private static final class_2300 ALL_ENTITIES_SELECTOR = new class_2300(Integer.MAX_VALUE, true, false, e -> true, class_2096.class_2099.field_9705, Function.identity(), null, class_2303.field_10850, false, null, null, null, true);

    public static void tryIO(TryIO tryIO) {
        try {
            tryIO.run();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static <T> T cast(Object o) {
        return (T)o;
    }

    @Nullable
    public static Pattern parseRegex(Object o) {
        if (o instanceof CharSequence || o instanceof NativeRegExp) {
            return UtilsJS.regex(o.toString());
        }
        if (o instanceof Pattern) {
            Pattern pattern = (Pattern)o;
            return pattern;
        }
        return null;
    }

    @Nullable
    public static Pattern regex(String string) {
        if (string.length() < 3) {
            return null;
        }
        Matcher matcher = REGEX_PATTERN.matcher(string);
        if (matcher.matches()) {
            int flags = 0;
            String f = matcher.group(2);
            block9: for (int i = 0; i < f.length(); ++i) {
                switch (f.charAt(i)) {
                    case 'd': {
                        flags |= 1;
                        continue block9;
                    }
                    case 'i': {
                        flags |= 2;
                        continue block9;
                    }
                    case 'x': {
                        flags |= 4;
                        continue block9;
                    }
                    case 'm': {
                        flags |= 8;
                        continue block9;
                    }
                    case 's': {
                        flags |= 0x20;
                        continue block9;
                    }
                    case 'u': {
                        flags |= 0x40;
                        continue block9;
                    }
                    case 'U': {
                        flags |= 0x100;
                    }
                }
            }
            return Pattern.compile(matcher.group(1), flags);
        }
        return null;
    }

    public static String toRegexString(Pattern pattern) {
        StringBuilder sb = new StringBuilder("/");
        sb.append(pattern.pattern());
        sb.append('/');
        int flags = pattern.flags();
        if ((flags & 1) != 0) {
            sb.append('d');
        }
        if ((flags & 2) != 0) {
            sb.append('i');
        }
        if ((flags & 4) != 0) {
            sb.append('x');
        }
        if ((flags & 8) != 0) {
            sb.append('m');
        }
        if ((flags & 0x20) != 0) {
            sb.append('s');
        }
        if ((flags & 0x40) != 0) {
            sb.append('u');
        }
        if ((flags & 0x100) != 0) {
            sb.append('U');
        }
        return sb.toString();
    }

    public static void queueIO(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Nullable
    public static Path getPath(Object o) {
        try {
            if (o instanceof Path) {
                return KubeJS.verifyFilePath((Path)o);
            }
            if (o == null || o.toString().isEmpty()) {
                return null;
            }
            return KubeJS.verifyFilePath(KubeJS.getGameDirectory().resolve(o.toString()));
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public static File getFileFromPath(Object o) {
        try {
            if (o instanceof File) {
                return KubeJS.verifyFilePath(((File)o).toPath()).toFile();
            }
            if (o == null || o.toString().isEmpty()) {
                return null;
            }
            return KubeJS.verifyFilePath(KubeJS.getGameDirectory().resolve(o.toString())).toFile();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public static Object copy(@Nullable Object o) {
        if (o instanceof Copyable) {
            Copyable copyable = (Copyable)o;
            return copyable.copy();
        }
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            return JsonIO.copy(json);
        }
        if (o instanceof class_2520) {
            class_2520 tag = (class_2520)o;
            return tag.method_10707();
        }
        return o;
    }

    @Nullable
    public static Object wrap(@Nullable Object o, JSObjectType type) {
        if (o == null || o instanceof WrappedJS || o instanceof class_2520 || o instanceof Number || o instanceof Character || o instanceof String || o instanceof Enum || o.getClass().isPrimitive() && !o.getClass().isArray()) {
            return o;
        }
        if (o instanceof CharSequence || o instanceof class_2960) {
            return o.toString();
        }
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            return UtilsJS.wrap(w.unwrap(), type);
        }
        if (o instanceof Map) {
            return o;
        }
        if (o instanceof Iterable) {
            Iterable itr = (Iterable)o;
            if (!type.checkList()) {
                return null;
            }
            ArrayList list = new ArrayList();
            for (Object o1 : itr) {
                list.add(o1);
            }
            return list;
        }
        if (o.getClass().isArray()) {
            if (type.checkList()) {
                return ListJS.ofArray(o);
            }
            return null;
        }
        if (o instanceof JsonPrimitive) {
            JsonPrimitive json = (JsonPrimitive)o;
            return JsonIO.toPrimitive((JsonElement)json);
        }
        if (o instanceof JsonObject) {
            JsonObject json = (JsonObject)o;
            if (!type.checkMap()) {
                return null;
            }
            HashMap map = new HashMap(json.size());
            for (Map.Entry entry : json.entrySet()) {
                map.put((String)entry.getKey(), entry.getValue());
            }
            return map;
        }
        if (o instanceof JsonNull || o instanceof class_2491) {
            return null;
        }
        if (o instanceof class_2487) {
            class_2487 tag = (class_2487)o;
            if (!type.checkMap()) {
                return null;
            }
            HashMap<String, class_2520> map = new HashMap<String, class_2520>(tag.method_10546());
            for (String s : tag.method_10541()) {
                map.put(s, tag.method_10580(s));
            }
            return map;
        }
        if (o instanceof class_2514) {
            class_2514 tag = (class_2514)o;
            return tag.method_10702();
        }
        if (o instanceof class_2519) {
            class_2519 tag = (class_2519)o;
            return tag.method_10714();
        }
        return o;
    }

    public static int parseInt(@Nullable Object object, int def) {
        if (object == null) {
            return def;
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            return num.intValue();
        }
        try {
            String s = object.toString();
            if (s.isEmpty()) {
                return def;
            }
            return Integer.parseInt(s);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static long parseLong(@Nullable Object object, long def) {
        if (object == null) {
            return def;
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            return num.longValue();
        }
        try {
            String s = object.toString();
            if (s.isEmpty()) {
                return def;
            }
            return Long.parseLong(s);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static double parseDouble(@Nullable Object object, double def) {
        if (object == null) {
            return def;
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            return num.doubleValue();
        }
        try {
            String s = object.toString();
            if (s.isEmpty()) {
                return def;
            }
            return Double.parseDouble(String.valueOf(object));
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static String getID(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return "minecraft:air";
        }
        if (s.indexOf(58) == -1) {
            return "minecraft:" + s;
        }
        return s;
    }

    public static class_2960 getMCID(@Nullable Context cx, @Nullable Object o) {
        String string;
        if (o == null) {
            return null;
        }
        if (o instanceof class_2960) {
            class_2960 id = (class_2960)o;
            return id;
        }
        if (o instanceof class_5321) {
            class_5321 key = (class_5321)o;
            return key.method_29177();
        }
        if (o instanceof JsonPrimitive) {
            JsonPrimitive p = (JsonPrimitive)o;
            string = p.getAsString();
        } else {
            string = o.toString();
        }
        String s = string;
        try {
            return new class_2960(s);
        }
        catch (class_151 ex) {
            ConsoleJS.getCurrent(cx).error("Could not create ID from '%s'!".formatted(s), ex);
            return null;
        }
    }

    public static String getNamespace(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return "minecraft";
        }
        int i = s.indexOf(58);
        return i == -1 ? "minecraft" : s.substring(0, i);
    }

    public static String getPath(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return "air";
        }
        int i = s.indexOf(58);
        return i == -1 ? s : s.substring(i + 1);
    }

    public static class_2680 parseBlockState(String string) {
        if (string.isEmpty()) {
            return class_2246.field_10124.method_9564();
        }
        int i = string.indexOf(91);
        boolean hasProperties = i >= 0 && string.indexOf(93) == string.length() - 1;
        class_2680 state = RegistryInfo.BLOCK.getValue(new class_2960(hasProperties ? string.substring(0, i) : string)).method_9564();
        if (hasProperties) {
            for (String s : string.substring(i + 1, string.length() - 1).split(",")) {
                Optional o;
                class_2769 p;
                String[] s1 = s.split("=", 2);
                if (s1.length != 2 || s1[0].isEmpty() || s1[1].isEmpty() || (p = state.method_26204().method_9595().method_11663(s1[0])) == null || !(o = p.method_11900(s1[1])).isPresent()) continue;
                state = (class_2680)state.method_11657(p, (Comparable)UtilsJS.cast(o.get()));
            }
        }
        return state;
    }

    public static <T> Predicate<T> onMatchDo(Predicate<T> predicate, Consumer<T> onMatch) {
        return t -> {
            boolean match = predicate.test(t);
            if (match) {
                onMatch.accept(t);
            }
            return match;
        };
    }

    public static List<class_1799> rollChestLoot(class_2960 id, @Nullable class_1297 entity) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        if (staticServer != null) {
            class_60 tables = staticServer.method_3857();
            class_52 table = tables.getLootTable(id);
            class_8567.class_8568 builder = entity != null ? new class_8567.class_8568((class_3218)entity.method_37908()).method_51877(class_181.field_1226, (Object)entity).method_51874(class_181.field_24424, (Object)entity.method_19538()) : new class_8567.class_8568(staticServer.method_30002()).method_51877(class_181.field_1226, null).method_51874(class_181.field_24424, (Object)class_243.field_1353);
            table.method_51882(builder.method_51875(class_173.field_1179), list::add);
        }
        return list;
    }

    public static void postModificationEvents() {
        BlockEvents.MODIFICATION.post(ScriptType.STARTUP, new BlockModificationEventJS());
        ItemEvents.MODIFICATION.post(ScriptType.STARTUP, new ItemModificationEventJS());
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            Class clz = (Class)type;
            return clz;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            if (rawType instanceof Class) {
                Class clz = (Class)rawType;
                return clz;
            }
        } else {
            if (type instanceof GenericArrayType) {
                GenericArrayType arrType = (GenericArrayType)type;
                Type componentType = arrType.getGenericComponentType();
                return Array.newInstance(UtilsJS.getRawType(componentType), 0).getClass();
            }
            if (type instanceof TypeVariable) {
                return Object.class;
            }
            if (type instanceof WildcardType) {
                WildcardType wildcard = (WildcardType)type;
                return UtilsJS.getRawType(wildcard.getUpperBounds()[0]);
            }
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, GenericArrayType, TypeVariable or WildcardType, but <" + type + "> is of type " + className);
    }

    public static String toMappedTypeString(Type type) {
        MinecraftRemapper remapper = RemappingHelper.getMinecraftRemapper();
        if (type instanceof Class) {
            Class clz = (Class)type;
            String mapped = remapper.getMappedClass(clz);
            if (Strings.isNullOrEmpty((String)mapped)) {
                return clz.getSimpleName();
            }
            return mapped.substring(mapped.lastIndexOf(46) + 1);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            StringBuilder sb = new StringBuilder();
            Type owner = paramType.getOwnerType();
            if (owner != null) {
                sb.append(UtilsJS.toMappedTypeString(owner));
                sb.append('.');
            }
            sb.append(UtilsJS.toMappedTypeString(UtilsJS.getRawType(paramType)));
            Type[] args = paramType.getActualTypeArguments();
            if (args.length > 0) {
                sb.append('<');
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(UtilsJS.toMappedTypeString(args[i]));
                }
                sb.append('>');
            }
            return sb.toString();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrType = (GenericArrayType)type;
            return UtilsJS.toMappedTypeString(arrType.getGenericComponentType()) + "[]";
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            StringBuilder sb = new StringBuilder(typeVar.getName());
            Type[] bounds = typeVar.getBounds();
            if (!(bounds.length <= 0 || bounds.length == 1 && Object.class.equals((Object)bounds[0]))) {
                sb.append(" extends ");
                for (int i = 0; i < bounds.length; ++i) {
                    if (i > 0) {
                        sb.append(" & ");
                    }
                    sb.append(UtilsJS.toMappedTypeString(bounds[i]));
                }
            }
            return sb.toString();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            StringBuilder sb = new StringBuilder().append("?");
            Type[] lowerBounds = wildcard.getLowerBounds();
            Type[] upperBounds = wildcard.getUpperBounds();
            if (lowerBounds.length > 1 || lowerBounds.length == 1 && lowerBounds[0] != null) {
                sb.append(" super ");
                for (int i = 0; i < lowerBounds.length; ++i) {
                    if (i > 0) {
                        sb.append(" & ");
                    }
                    sb.append(UtilsJS.toMappedTypeString(lowerBounds[i]));
                }
            } else if (upperBounds.length > 1 || upperBounds.length == 1 && !Object.class.equals((Object)upperBounds[0])) {
                sb.append(" extends ");
                for (int i = 0; i < upperBounds.length; ++i) {
                    if (i > 0) {
                        sb.append(" & ");
                    }
                    sb.append(UtilsJS.toMappedTypeString(upperBounds[i]));
                }
            }
            return sb.toString();
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, GenericArrayType, TypeVariable or WildcardType, but <" + type + "> is of type " + className);
    }

    public static String snakeCaseToCamelCase(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        String[] s = SNAKE_CASE_SPLIT.split(string, 0);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String value : s) {
            if (value.isEmpty()) continue;
            if (first) {
                first = false;
                sb.append(value);
                continue;
            }
            sb.append(Character.toUpperCase(value.charAt(0)));
            sb.append(value, 1, value.length());
        }
        return sb.toString();
    }

    public static String snakeCaseToTitleCase(String string) {
        StringJoiner joiner = new StringJoiner(" ");
        String[] split = string.split("_");
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            String titleCase = UtilsJS.toTitleCase(s, i == 0);
            joiner.add(titleCase);
        }
        return joiner.toString();
    }

    public static class_6017 intProviderOf(Object o) {
        List l;
        if (o instanceof Number) {
            Number n = (Number)o;
            return class_6016.method_34998((int)n.intValue());
        }
        if (o instanceof List && !(l = (List)o).isEmpty()) {
            Number min = (Number)l.get(0);
            Number max = l.size() >= 2 ? (Number)((Number)l.get(1)) : (Number)min;
            return class_6019.method_35017((int)min.intValue(), (int)max.intValue());
        }
        if (o instanceof Map) {
            Optional decoded;
            Map m = (Map)o;
            class_6019 intBounds = UtilsJS.parseIntBounds(m);
            if (intBounds != null) {
                return intBounds;
            }
            if (m.containsKey("clamped")) {
                class_6017 source = UtilsJS.intProviderOf(m.get("clamped"));
                class_6019 clampTo = UtilsJS.parseIntBounds(m);
                if (clampTo != null) {
                    return class_6334.method_36255((class_6017)source, (int)clampTo.method_35009(), (int)clampTo.method_35011());
                }
            } else if (m.containsKey("clamped_normal")) {
                class_6019 clampTo = UtilsJS.parseIntBounds(m);
                int mean = ((Number)m.get("mean")).intValue();
                int deviation = ((Number)m.get("deviation")).intValue();
                if (clampTo != null) {
                    return class_6728.method_39156((float)mean, (float)deviation, (int)clampTo.method_35009(), (int)clampTo.method_35011());
                }
            }
            if ((decoded = class_6017.field_29946.parse((DynamicOps)class_2509.field_11560, (Object)NBTUtils.toTagCompound((Object)m)).result()).isPresent()) {
                return (class_6017)decoded.get();
            }
        }
        return class_6016.method_34998((int)0);
    }

    private static class_6019 parseIntBounds(Map<String, Object> m) {
        Object object = m.get("bounds");
        if (object instanceof List) {
            List bounds = (List)object;
            return class_6019.method_35017((int)UtilsJS.parseInt(bounds.get(0), 0), (int)UtilsJS.parseInt(bounds.get(1), 0));
        }
        if (m.containsKey("min") && m.containsKey("max")) {
            return class_6019.method_35017((int)((Number)m.get("min")).intValue(), (int)((Number)m.get("max")).intValue());
        }
        if (m.containsKey("min_inclusive") && m.containsKey("max_inclusive")) {
            return class_6019.method_35017((int)((Number)m.get("min_inclusive")).intValue(), (int)((Number)m.get("max_inclusive")).intValue());
        }
        if (m.containsKey("value")) {
            int f = ((Number)m.get("value")).intValue();
            return class_6019.method_35017((int)f, (int)f);
        }
        return null;
    }

    public static class_5658 numberProviderOf(Object o) {
        List l;
        if (o instanceof Number) {
            Number n = (Number)o;
            float f = n.floatValue();
            return class_5662.method_32462((float)f, (float)f);
        }
        if (o instanceof List && !(l = (List)o).isEmpty()) {
            Number min = (Number)l.get(0);
            Number max = l.size() >= 2 ? (Number)((Number)l.get(1)) : (Number)min;
            return class_5662.method_32462((float)min.floatValue(), (float)max.floatValue());
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            if (m.containsKey("min") && m.containsKey("max")) {
                return class_5662.method_32462((float)((Number)m.get("min")).intValue(), (float)((Number)m.get("max")).floatValue());
            }
            if (m.containsKey("n") && m.containsKey("p")) {
                return class_40.method_273((int)((Number)m.get("n")).intValue(), (float)((Number)m.get("p")).floatValue());
            }
            if (m.containsKey("value")) {
                float f = ((Number)m.get("value")).floatValue();
                return class_5662.method_32462((float)f, (float)f);
            }
        }
        return class_44.method_32448((float)0.0f);
    }

    public static JsonElement numberProviderJson(class_5658 gen) {
        return class_5270.method_27860().create().toJsonTree((Object)gen);
    }

    public static class_243 vec3Of(@Nullable Object o) {
        List list;
        if (o instanceof class_243) {
            class_243 vec = (class_243)o;
            return vec;
        }
        if (o instanceof class_1297) {
            class_1297 entity = (class_1297)o;
            return entity.method_19538();
        }
        if (o instanceof List && (list = (List)o).size() >= 3) {
            return new class_243(UtilsJS.parseDouble(list.get(0), 0.0), UtilsJS.parseDouble(list.get(1), 0.0), UtilsJS.parseDouble(list.get(2), 0.0));
        }
        if (o instanceof class_2338) {
            class_2338 pos = (class_2338)o;
            return new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        }
        if (o instanceof BlockContainerJS) {
            BlockContainerJS block = (BlockContainerJS)o;
            return new class_243((double)block.getPos().method_10263() + 0.5, (double)block.getPos().method_10264() + 0.5, (double)block.getPos().method_10260() + 0.5);
        }
        return class_243.field_1353;
    }

    public static class_2338 blockPosOf(@Nullable Object o) {
        List list;
        if (o instanceof class_2338) {
            class_2338 pos = (class_2338)o;
            return pos;
        }
        if (o instanceof List && (list = (List)o).size() >= 3) {
            return new class_2338(UtilsJS.parseInt(list.get(0), 0), UtilsJS.parseInt(list.get(1), 0), UtilsJS.parseInt(list.get(2), 0));
        }
        if (o instanceof BlockContainerJS) {
            BlockContainerJS block = (BlockContainerJS)o;
            return block.getPos();
        }
        if (o instanceof class_243) {
            class_243 vec = (class_243)o;
            return class_2338.method_49637((double)vec.field_1352, (double)vec.field_1351, (double)vec.field_1350);
        }
        return class_2338.field_10980;
    }

    public static Collection<class_2680> getAllBlockStates() {
        if (ALL_STATE_CACHE != null) {
            return ALL_STATE_CACHE;
        }
        HashSet states = new HashSet();
        for (class_2248 block : RegistryInfo.BLOCK.getArchitecturyRegistrar()) {
            states.addAll(block.method_9595().method_11662());
        }
        ALL_STATE_CACHE = Collections.unmodifiableCollection(states);
        return ALL_STATE_CACHE;
    }

    public static String toTitleCase(String s) {
        return UtilsJS.toTitleCase(s, false);
    }

    public static String toTitleCase(String s, boolean ignoreSpecial) {
        if (s.isEmpty()) {
            return "";
        }
        if (!ignoreSpecial && ALWAYS_LOWER_CASE.contains(s)) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String getMobTypeId(class_1310 type) {
        if (type == class_1310.field_6289) {
            return "undead";
        }
        if (type == class_1310.field_6293) {
            return "arthropod";
        }
        if (type == class_1310.field_6291) {
            return "illager";
        }
        if (type == class_1310.field_6292) {
            return "water";
        }
        return "unknown";
    }

    public static class_1311 mobCategoryByName(String s) {
        return MiscPlatformHelper.get().getMobCategory(s);
    }

    public static String stripIdForEvent(class_2960 id) {
        return UtilsJS.stripEventName(id.toString());
    }

    public static String getUniqueId(JsonElement json) {
        return UtilsJS.getUniqueId(json, Function.identity());
    }

    public static <T> String getUniqueId(T input, Codec<T> codec) {
        return UtilsJS.getUniqueId(input, (T o) -> (JsonElement)codec.encodeStart((DynamicOps)JsonOps.COMPRESSED, o).getOrThrow(false, str -> {
            throw new RuntimeException("Could not encode element to JSON: " + str);
        }));
    }

    private static <T> String getUniqueId(T input, Function<T, JsonElement> toJson) {
        return JsonIO.getJsonHashString(toJson.apply(input));
    }

    public static String stripEventName(String s) {
        return s.replaceAll("[/:]", ".").replace('-', '_');
    }

    public static class_2300 entitySelector(@Nullable Object o) {
        if (o == null) {
            return ALL_ENTITIES_SELECTOR;
        }
        if (o instanceof class_2300) {
            class_2300 s = (class_2300)o;
            return s;
        }
        String s = o.toString();
        if (s.isBlank()) {
            return ALL_ENTITIES_SELECTOR;
        }
        class_2300 sel = ENTITY_SELECTOR_CACHE.get(s);
        if (sel == null) {
            sel = ALL_ENTITIES_SELECTOR;
            try {
                sel = new class_2303(new StringReader(s), true).method_9882();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ENTITY_SELECTOR_CACHE.put(s, sel);
        return sel;
    }

    @Nullable
    public static class_1761 findCreativeTab(class_2960 id) {
        return RegistryInfo.CREATIVE_MODE_TAB.getValue(id);
    }

    public static <T> T makeFunctionProxy(ScriptType type, Class<T> targetClass, BaseFunction function) {
        return UtilsJS.cast(NativeJavaObject.createInterfaceAdapter((Context)type.manager.get().context, targetClass, (ScriptableObject)function));
    }

    public static TemporalAmount getTemporalAmount(Object o) {
        if (o instanceof TemporalAmount) {
            TemporalAmount d = (TemporalAmount)o;
            return d;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return Duration.ofMillis(n.longValue());
        }
        if (o instanceof CharSequence) {
            Matcher matcher = TEMPORAL_AMOUNT_PATTERN.matcher(o.toString());
            long millis = 0L;
            long nanos = 0L;
            long ticks = -1L;
            block24: while (matcher.find()) {
                double amount = Double.parseDouble(matcher.group(1));
                switch (matcher.group(2)) {
                    case "t": {
                        if (ticks == -1L) {
                            ticks = 0L;
                        }
                        ticks += (long)amount;
                        continue block24;
                    }
                    case "ns": {
                        nanos += (long)amount;
                        continue block24;
                    }
                    case "ms": {
                        millis += (long)amount;
                        continue block24;
                    }
                    case "s": {
                        millis += (long)(amount * 1000.0);
                        continue block24;
                    }
                    case "m": {
                        millis += (long)(amount * 60000.0);
                        continue block24;
                    }
                    case "h": {
                        millis += (long)(amount * 60000.0) * 60L;
                        continue block24;
                    }
                    case "d": {
                        millis += (long)(amount * 86400.0) * 1000L;
                        continue block24;
                    }
                    case "w": {
                        millis += (long)(amount * 86400.0) * 7000L;
                        continue block24;
                    }
                    case "M": {
                        millis += (long)(amount * 3.1556952E7 / 12.0) * 1000L;
                        continue block24;
                    }
                    case "y": {
                        millis += (long)(amount * 3.1556952E7) * 1000L;
                        continue block24;
                    }
                }
                throw new IllegalArgumentException("Invalid temporal unit: " + matcher.group(2));
            }
            if (ticks != -1L) {
                return new TickDuration(ticks + millis / 50L);
            }
            return Duration.ofMillis(millis).plusNanos(nanos);
        }
        throw new IllegalArgumentException("Invalid temporal amount: " + o);
    }

    public static long getTickDuration(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            return n.longValue();
        }
        if (o instanceof JsonPrimitive) {
            JsonPrimitive json = (JsonPrimitive)o;
            return json.getAsLong();
        }
        TemporalAmount t = UtilsJS.getTemporalAmount(o);
        if (t instanceof TickDuration) {
            TickDuration d = (TickDuration)t;
            return d.ticks();
        }
        if (t instanceof Duration) {
            Duration d = (Duration)t;
            return d.toMillis() / 50L;
        }
        return 0L;
    }

    public static Duration getDuration(Object o) {
        TemporalAmount t = UtilsJS.getTemporalAmount(o);
        if (t instanceof Duration) {
            Duration d = (Duration)t;
            return d;
        }
        if (t instanceof TickDuration) {
            TickDuration d = (TickDuration)t;
            return Duration.ofMillis(d.ticks() * 50L);
        }
        Duration d = Duration.ZERO;
        for (TemporalUnit unit : t.getUnits()) {
            d = d.plus(t.get(unit), unit);
        }
        return d;
    }

    public static void writeColor(class_2540 buf, Color color) {
        buf.writeInt(color.getArgbJS());
    }

    public static Color readColor(class_2540 buf) {
        return new SimpleColorWithAlpha(buf.readInt());
    }

    public static void appendTimestamp(StringBuilder builder, Calendar calendar) {
        int h = calendar.get(11);
        int m = calendar.get(12);
        int s = calendar.get(13);
        if (h < 10) {
            builder.append('0');
        }
        builder.append(h);
        builder.append(':');
        if (m < 10) {
            builder.append('0');
        }
        builder.append(m);
        builder.append(':');
        if (s < 10) {
            builder.append('0');
        }
        builder.append(s);
    }

    @FunctionalInterface
    public static interface TryIO {
        public void run() throws IOException;
    }
}

