/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema;

import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.bindings.event.StartupEvents;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.RecipeSchemaRegistryEventJS;
import dev.latvian.mods.kubejs.recipe.schema.JsonRecipeSchemaType;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import dev.latvian.mods.kubejs.recipe.schema.RegisterRecipeSchemasEvent;
import dev.latvian.mods.kubejs.recipe.schema.minecraft.ShapedRecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.minecraft.ShapelessRecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.minecraft.SpecialRecipeSchema;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1865;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class RecipeNamespace
extends LinkedHashMap<String, RecipeSchemaType> {
    private static Map<String, class_2960> mappedRecipes;
    private static Map<String, RecipeNamespace> all;
    public final String name;

    public static Map<String, RecipeNamespace> getAll() {
        if (all == null) {
            all = new HashMap<String, RecipeNamespace>();
            mappedRecipes = new HashMap<String, class_2960>();
            for (Map.Entry<class_5321<class_1865>, class_1865> entry : RegistryInfo.RECIPE_SERIALIZER.entrySet()) {
                RecipeNamespace ns = all.computeIfAbsent(entry.getKey().method_29177().method_12836(), RecipeNamespace::new);
                ns.put(entry.getKey().method_29177().method_12832(), new JsonRecipeSchemaType(ns, entry.getKey().method_29177(), entry.getValue()));
            }
            KubeJSPlugins.forEachPlugin(new RegisterRecipeSchemasEvent(all, mappedRecipes), KubeJSPlugin::registerRecipeSchemas);
            StartupEvents.RECIPE_SCHEMA_REGISTRY.post(ScriptType.STARTUP, new RecipeSchemaRegistryEventJS(all, mappedRecipes));
        }
        return all;
    }

    public static Map<String, class_2960> getMappedRecipes() {
        RecipeNamespace.getAll();
        return mappedRecipes;
    }

    public RecipeNamespace(String name) {
        this.name = name;
    }

    public RecipeNamespace register(String id, RecipeSchema type) {
        this.put(id, new RecipeSchemaType(this, new class_2960(this.name, id), type));
        return this;
    }

    public RecipeNamespace registerBasic(String id, RecipeKey<?> ... keys) {
        return this.register(id, new RecipeSchema(keys));
    }

    public RecipeNamespace shaped(String id) {
        return this.register(id, ShapedRecipeSchema.SCHEMA);
    }

    public RecipeNamespace shapeless(String id) {
        return this.register(id, ShapelessRecipeSchema.SCHEMA);
    }

    public RecipeNamespace special(String id) {
        return this.register(id, SpecialRecipeSchema.SCHEMA);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

