/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.mod.util.color.Color;
import dev.latvian.mods.rhino.mod.util.color.SimpleColor;
import dev.latvian.mods.rhino.mod.util.color.SimpleColorWithAlpha;
import dev.latvian.mods.rhino.mod.wrapper.ColorWrapper;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_2338;
import net.minecraft.class_2457;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface BlockTintFunction {
    public static final BlockTintFunction GRASS = (s, l, p, i) -> new SimpleColor(l == null || p == null ? class_1933.method_8377((double)0.5, (double)1.0) : class_1163.method_4962((class_1920)l, (class_2338)p));
    public static final Color DEFAULT_FOLIAGE_COLOR = new SimpleColor(class_1926.method_8341());
    public static final BlockTintFunction FOLIAGE = (s, l, p, i) -> l == null || p == null ? DEFAULT_FOLIAGE_COLOR : new SimpleColor(class_1163.method_4966((class_1920)l, (class_2338)p));
    public static final Fixed EVERGREEN_FOLIAGE = new Fixed((Color)new SimpleColor(class_1926.method_8342()));
    public static final Fixed BIRCH_FOLIAGE = new Fixed((Color)new SimpleColor(class_1926.method_8343()));
    public static final Fixed MANGROVE_FOLIAGE = new Fixed((Color)new SimpleColor(class_1926.method_43717()));
    public static final BlockTintFunction WATER = (s, l, p, i) -> l == null || p == null ? null : new SimpleColorWithAlpha(class_1163.method_4961((class_1920)l, (class_2338)p));
    public static final Color[] REDSTONE_COLORS = new Color[16];
    public static final BlockTintFunction REDSTONE = (state, level, pos, index) -> {
        if (REDSTONE_COLORS[0] == null) {
            for (int i = 0; i < REDSTONE_COLORS.length; ++i) {
                BlockTintFunction.REDSTONE_COLORS[i] = new SimpleColor(class_2457.method_10487((int)i));
            }
        }
        return REDSTONE_COLORS[(Integer)state.method_11654((class_2769)class_2741.field_12511)];
    };

    public Color getColor(class_2680 var1, @Nullable class_1920 var2, @Nullable class_2338 var3, int var4);

    @Nullable
    public static BlockTintFunction of(Context cx, Object o) {
        if (o == null || Undefined.isUndefined((Object)o)) {
            return null;
        }
        if (o instanceof BlockTintFunction) {
            BlockTintFunction f = (BlockTintFunction)o;
            return f;
        }
        if (o instanceof List) {
            List list = (List)o;
            Mapped map = new Mapped();
            for (int i = 0; i < list.size(); ++i) {
                BlockTintFunction f = BlockTintFunction.of(cx, list.get(i));
                if (f == null) continue;
                map.map.put(i, (Object)f);
            }
            return map;
        }
        if (o instanceof CharSequence) {
            BlockTintFunction f;
            switch (o.toString()) {
                case "grass": {
                    BlockTintFunction blockTintFunction = GRASS;
                    break;
                }
                case "foliage": {
                    BlockTintFunction blockTintFunction = FOLIAGE;
                    break;
                }
                case "evergreen_foliage": {
                    BlockTintFunction blockTintFunction = EVERGREEN_FOLIAGE;
                    break;
                }
                case "birch_foliage": {
                    BlockTintFunction blockTintFunction = BIRCH_FOLIAGE;
                    break;
                }
                case "mangrove_foliage": {
                    BlockTintFunction blockTintFunction = MANGROVE_FOLIAGE;
                    break;
                }
                case "water": {
                    BlockTintFunction blockTintFunction = WATER;
                    break;
                }
                case "redstone": {
                    BlockTintFunction blockTintFunction = REDSTONE;
                    break;
                }
                default: {
                    BlockTintFunction blockTintFunction = f = null;
                }
            }
            if (f != null) {
                return f;
            }
        } else if (o instanceof BaseFunction) {
            BaseFunction function = (BaseFunction)o;
            return (BlockTintFunction)NativeJavaObject.createInterfaceAdapter((Context)cx, BlockTintFunction.class, (ScriptableObject)function);
        }
        return new Fixed(ColorWrapper.of((Object)o));
    }

    public static class Mapped
    implements BlockTintFunction {
        public final Int2ObjectMap<BlockTintFunction> map = new Int2ObjectArrayMap(1);

        @Override
        public Color getColor(class_2680 state, @Nullable class_1920 level, @Nullable class_2338 pos, int index) {
            BlockTintFunction f = (BlockTintFunction)this.map.get(index);
            return f == null ? null : f.getColor(state, level, pos, index);
        }
    }

    public record Fixed(Color color) implements BlockTintFunction
    {
        @Override
        public Color getColor(class_2680 state, @Nullable class_1920 level, @Nullable class_2338 pos, int index) {
            return this.color;
        }
    }
}

