/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.level.FireworksJS;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.mod.util.JsonUtils;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

@Info(value="Various item related helper methods")
public interface ItemWrapper {
    public static final UUID KJS_BASE_ATTACK_DAMAGE_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    public static final UUID KJS_BASE_ATTACK_SPEED_UUID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    public static final UUID[] KJS_ARMOR_MODIFIER_UUID_PER_SLOT = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};

    @Info(value="Returns an ItemStack of the input")
    public static class_1799 of(class_1799 in) {
        return in;
    }

    @Info(value="Returns an ItemStack of the input, with the specified count")
    public static class_1799 of(class_1799 in, int count) {
        return in.kjs$withCount(count);
    }

    @Info(value="Returns an ItemStack of the input, with the specified NBT data")
    public static class_1799 of(class_1799 in, class_2487 tag) {
        return in.kjs$withNBT(tag);
    }

    @Info(value="Returns an ItemStack of the input, with the specified count and NBT data")
    public static class_1799 of(class_1799 in, int count, class_2487 nbt) {
        class_1799 is = in.kjs$withNBT(nbt);
        is.method_7939(count);
        return is;
    }

    @Info(value="Returns an ItemStack of the input, with the specified NBT data")
    public static class_1799 withNBT(class_1799 in, class_2487 nbt) {
        return in.kjs$withNBT(nbt);
    }

    @Info(value="Get a list of most items in the game. Items not in a creative tab are ignored")
    public static List<class_1799> getList() {
        return ItemStackJS.getList();
    }

    @Info(value="Get a list of all the item ids in the game")
    public static List<String> getTypeList() {
        return ItemStackJS.getTypeList();
    }

    public static Map<class_2960, Collection<class_1799>> getTypeToStackMap() {
        return ItemStackJS.getTypeToStacks();
    }

    public static Collection<class_1799> getVariants(class_1799 item) {
        return ItemWrapper.getTypeToStackMap().get(item.kjs$getIdLocation());
    }

    @Info(value="Get the item that represents air/an empty slot")
    public static class_1799 getEmpty() {
        return class_1799.field_8037;
    }

    @Info(value="Returns a Firework with the input properties")
    public static FireworksJS fireworks(Map<String, Object> properties) {
        return FireworksJS.of(properties);
    }

    @Info(value="Gets an Item from an item id")
    public static class_1792 getItem(class_2960 id) {
        return RegistryInfo.ITEM.getValue(id);
    }

    @Info(value="Gets an items id from the Item")
    @Nullable
    public static class_2960 getId(class_1792 item) {
        return RegistryInfo.ITEM.getId(item);
    }

    @Info(value="Checks if the provided item id exists in the registry")
    public static boolean exists(class_2960 id) {
        return RegistryInfo.ITEM.hasValue(id);
    }

    @Info(value="Checks if the passed in object is an ItemStack.\nNote that this does not mean it will not function as an ItemStack if passed to something that requests one.\n")
    public static boolean isItem(@Nullable Object o) {
        return o instanceof ItemStackJS;
    }

    public static class_1799 playerHead(String name) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8575);
        stack.method_7948().method_10582("SkullOwner", name);
        return stack;
    }

    public static class_1799 playerHead(UUID uuid, String textureBase64) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8575);
        class_2487 so = stack.method_7911("SkullOwner");
        so.method_25927("Id", uuid);
        if (textureBase64 != null && !textureBase64.isBlank()) {
            class_2487 properties = new class_2487();
            class_2499 list = new class_2499();
            class_2487 texture = new class_2487();
            texture.method_10582("Value", textureBase64);
            list.add((Object)texture);
            properties.method_10566("textures", (class_2520)list);
            so.method_10566("Properties", (class_2520)properties);
        }
        return stack;
    }

    public static class_1799 playerHeadFromUrl(String url) {
        JsonObject root = new JsonObject();
        JsonObject textures = new JsonObject();
        JsonObject skin = new JsonObject();
        skin.addProperty("url", url);
        textures.add("SKIN", (JsonElement)skin);
        root.add("textures", (JsonElement)textures);
        byte[] bytes = JsonUtils.toString((JsonElement)root).getBytes(StandardCharsets.UTF_8);
        return ItemWrapper.playerHead(UUID.nameUUIDFromBytes(bytes), Base64.getEncoder().encodeToString(bytes));
    }

    public static class_1799 playerHeadFromSkinHash(String hash) {
        return ItemWrapper.playerHeadFromUrl("https://textures.minecraft.net/texture/" + hash);
    }
}

