/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mixin.shared.network.microopt;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.EncoderException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import me.steinborn.krypton.mod.shared.network.util.VarIntUtil;
import net.minecraft.network.FriendlyByteBuf;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={FriendlyByteBuf.class})
public abstract class PacketByteBufMixin
extends ByteBuf {
    @Shadow
    @Final
    private ByteBuf f_130049_;

    @Shadow
    public abstract int writeCharSequence(CharSequence var1, Charset var2);

    @Overwrite
    public static int m_130053_(int value) {
        return VarIntUtil.getVarIntLength(value);
    }

    @Overwrite
    public FriendlyByteBuf m_130072_(String string, int i) {
        if (string.length() > i) {
            throw new EncoderException("String too big (was " + string.length() + " characters, max " + i + ")");
        }
        int utf8Bytes = ByteBufUtil.utf8Bytes((CharSequence)string);
        if (utf8Bytes > i * 3) {
            throw new EncoderException("String too big (was " + utf8Bytes + " bytes encoded, max " + i * 3 + ")");
        }
        this.m_130130_(utf8Bytes);
        this.writeCharSequence(string, StandardCharsets.UTF_8);
        return new FriendlyByteBuf(this.f_130049_);
    }

    @Overwrite
    public FriendlyByteBuf m_130130_(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            this.f_130049_.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            int w = (value & 0x7F | 0x80) << 8 | value >>> 7;
            this.f_130049_.writeShort(w);
        } else {
            PacketByteBufMixin.writeVarIntFull(this.f_130049_, value);
        }
        return new FriendlyByteBuf(this.f_130049_);
    }

    private static void writeVarIntFull(ByteBuf buf, int value) {
        if ((value & 0xFFFFFF80) == 0) {
            buf.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            int w = (value & 0x7F | 0x80) << 8 | value >>> 7;
            buf.writeShort(w);
        } else if ((value & 0xFFE00000) == 0) {
            int w = (value & 0x7F | 0x80) << 16 | (value >>> 7 & 0x7F | 0x80) << 8 | value >>> 14;
            buf.writeMedium(w);
        } else if ((value & 0xF0000000) == 0) {
            int w = (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | value >>> 21;
            buf.writeInt(w);
        } else {
            int w = (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | (value >>> 21 & 0x7F | 0x80);
            buf.writeInt(w);
            buf.writeByte(value >>> 28);
        }
    }
}

