/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1790;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3544;
import net.minecraft.class_5250;
import org.lwjgl.system.NonnullDefault;
import xerca.xercapaint.CanvasType;
import xerca.xercapaint.client.ModClient;
import xerca.xercapaint.entity.Entities;
import xerca.xercapaint.entity.EntityCanvas;

@NonnullDefault
public class ItemCanvas
extends class_1790 {
    private final CanvasType canvasType;

    ItemCanvas(CanvasType canvasType) {
        super(Entities.CANVAS, new FabricItemSettings().method_7889(1));
        this.canvasType = canvasType;
    }

    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, @Nonnull class_1268 hand) {
        if (worldIn.field_9236) {
            ModClient.showCanvasGui(playerIn);
        }
        return new class_1271(class_1269.field_5812, (Object)playerIn.method_5998(hand));
    }

    public class_1269 method_7884(class_1838 context) {
        class_2338 blockpos = context.method_8037();
        class_2350 direction = context.method_8038();
        class_2338 pos = blockpos.method_10093(direction);
        class_1657 player = context.method_8036();
        class_1799 itemstack = context.method_8041();
        if (player != null) {
            if (!this.method_7834(player, direction, itemstack, pos)) {
                if (context.method_8045().field_9236) {
                    ModClient.showCanvasGui(player);
                }
            } else {
                EntityCanvas entityCanvas;
                class_1937 world = context.method_8045();
                class_2487 tag = itemstack.method_7969();
                if (tag == null || !tag.method_10545("pixels") || !tag.method_10545("name")) {
                    if (context.method_8045().field_9236) {
                        ModClient.showCanvasGui(player);
                    }
                    return class_1269.field_5812;
                }
                int rotation = ItemCanvas.getRotation(direction, blockpos, player);
                if (!world.field_9236 && (entityCanvas = new EntityCanvas(world, tag, pos, direction, this.canvasType, rotation)).method_6888()) {
                    entityCanvas.method_6894();
                    world.method_8649((class_1297)entityCanvas);
                    itemstack.method_7934(1);
                }
            }
        }
        return class_1269.field_5812;
    }

    private static int getRotation(class_2350 direction, class_2338 blockpos, class_1657 player) {
        int rotation = 0;
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            double xDiff = (double)blockpos.method_10263() - player.method_23317();
            double zDiff = (double)blockpos.method_10260() - player.method_23321();
            if (Math.abs(xDiff) > Math.abs(zDiff)) {
                rotation = xDiff > 0.0 ? 1 : 3;
            } else if (zDiff > 0.0) {
                rotation = 2;
            }
            if (direction == class_2350.field_11033 && Math.abs(xDiff) < Math.abs(zDiff)) {
                rotation += 2;
            }
        }
        return rotation;
    }

    public static boolean hasTitle(@Nonnull class_1799 stack) {
        class_2487 tag;
        if (stack.method_7985() && (tag = stack.method_7969()) != null) {
            String s = tag.method_10558("title");
            return !class_3544.method_15438((String)s);
        }
        return false;
    }

    public static class_2561 getFullLabel(@Nonnull class_1799 stack) {
        Object labelString = "";
        int generation = 0;
        class_2561 title = ItemCanvas.getCustomTitle(stack);
        if (title != null) {
            labelString = (String)labelString + title.getString() + " ";
        }
        if (stack.method_7985() && stack.method_7969() != null) {
            class_2487 tag = stack.method_7969();
            String s = tag.method_10558("author");
            if (!class_3544.method_15438((String)s)) {
                labelString = (String)labelString + class_2561.method_43469((String)"canvas.byAuthor", (Object[])new Object[]{s}).getString() + " ";
            }
            generation = tag.method_10550("generation");
        }
        class_5250 label = class_2561.method_43470((String)labelString);
        if (generation == 1) {
            label.method_27692(class_124.field_1054);
        } else if (generation >= 3) {
            label.method_27692(class_124.field_1080);
        }
        return label;
    }

    @Nullable
    public static class_2561 getCustomTitle(@Nonnull class_1799 stack) {
        String s;
        class_2487 tag;
        if (stack.method_7985() && (tag = stack.method_7969()) != null && !class_3544.method_15438((String)(s = tag.method_10558("title")))) {
            return class_2561.method_43470((String)s);
        }
        return null;
    }

    @Nonnull
    public class_2561 method_7864(@Nonnull class_1799 stack) {
        class_2561 comp = ItemCanvas.getCustomTitle(stack);
        if (comp != null) {
            return comp;
        }
        return super.method_7864(stack);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        if (stack.method_7985() && stack.method_7969() != null) {
            int generation;
            class_2487 tag = stack.method_7969();
            String s = tag.method_10558("author");
            if (!class_3544.method_15438((String)s)) {
                tooltip.add((class_2561)class_2561.method_43469((String)"canvas.byAuthor", (Object[])new Object[]{s}));
            }
            if ((generation = tag.method_10550("generation")) > 0) {
                tooltip.add((class_2561)class_2561.method_43471((String)("canvas.generation." + (generation - 1))).method_27692(class_124.field_1080));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"canvas.empty").method_27692(class_124.field_1080));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_7886(class_1799 stack) {
        class_2487 tag;
        if (stack.method_7985() && (tag = stack.method_7969()) != null) {
            int generation = tag.method_10550("generation");
            return generation > 0;
        }
        return false;
    }

    public int getWidth() {
        return CanvasType.getWidth(this.canvasType);
    }

    public int getHeight() {
        return CanvasType.getHeight(this.canvasType);
    }

    public CanvasType getCanvasType() {
        return this.canvasType;
    }

    protected boolean method_7834(class_1657 playerIn, class_2350 directionIn, class_1799 itemStackIn, class_2338 posIn) {
        if (this.canvasType == CanvasType.SMALL) {
            return class_1937.method_25953((class_2338)posIn) && playerIn.method_7343(posIn, directionIn, itemStackIn);
        }
        return !directionIn.method_10166().method_10178() && playerIn.method_7343(posIn, directionIn, itemStackIn);
    }
}

