/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.entity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import xerca.xercapaint.CanvasType;
import xerca.xercapaint.Mod;
import xerca.xercapaint.entity.Entities;
import xerca.xercapaint.item.Items;
import xerca.xercapaint.packets.ClientboundAddCanvasPacket;
import xerca.xercapaint.packets.PictureRequestPacket;

public class EntityCanvas
extends class_1530 {
    private String canvasName;
    private String canvasTitle;
    private String canvasAuthor;
    private int canvasVersion;
    private int canvasGeneration = 0;
    private boolean canvasSigned;
    private int tickCounter1 = 0;
    private CanvasType canvasType;
    private static final class_2940<Integer> ROTATION = class_2945.method_12791(EntityCanvas.class, (class_2941)class_2943.field_13327);
    public static final Map<String, Picture> PICTURES = Maps.newHashMap();
    public static final Set<String> PICTURE_REQUESTS = Sets.newHashSet();

    public EntityCanvas(class_1937 world, class_2487 canvasNBT, class_2338 pos, class_2350 facing, CanvasType canvasType, int rotation) {
        super(Entities.CANVAS, world, pos);
        this.canvasName = canvasNBT.method_10558("name");
        this.canvasVersion = canvasNBT.method_10550("v");
        if (canvasNBT.method_10545("title") && canvasNBT.method_10545("author")) {
            this.canvasSigned = true;
            this.canvasTitle = canvasNBT.method_10558("title");
            this.canvasAuthor = canvasNBT.method_10558("author");
            this.canvasGeneration = canvasNBT.method_10550("generation");
        } else {
            this.canvasSigned = false;
        }
        this.canvasType = canvasType;
        this.setRotation(rotation);
        this.method_6892(facing);
        Picture picture = PICTURES.get(this.canvasName);
        if (picture == null || picture.version < this.canvasVersion) {
            PICTURES.put(this.canvasName, new Picture(this.canvasVersion, canvasNBT.method_10561("pixels")));
        }
    }

    public EntityCanvas(class_1299<? extends class_1530> entityCanvasEntityType, class_1937 world) {
        super(entityCanvasEntityType, world);
    }

    protected void method_5693() {
        this.method_5841().method_12784(ROTATION, (Object)0);
    }

    public CanvasType getCanvasType() {
        return this.canvasType;
    }

    public int method_6897() {
        return CanvasType.getWidth(this.canvasType);
    }

    public int method_6891() {
        return CanvasType.getHeight(this.canvasType);
    }

    protected float method_18378(@NotNull class_4050 poseIn, @NotNull class_4048 sizeIn) {
        return 0.0f;
    }

    public String getCanvasName() {
        return this.canvasName;
    }

    public int getCanvasVersion() {
        return this.canvasVersion;
    }

    public void method_6889(@Nullable class_1297 brokenEntity) {
        if (this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            Picture picture;
            class_1799 canvasItem;
            this.method_5783(class_3417.field_14809, 1.0f, 1.0f);
            if (brokenEntity instanceof class_1657) {
                class_1657 playerentity = (class_1657)brokenEntity;
                if (playerentity.method_31549().field_7477) {
                    return;
                }
            }
            if (this.canvasType == CanvasType.SMALL) {
                canvasItem = new class_1799((class_1935)Items.ITEM_CANVAS);
            } else if (this.canvasType == CanvasType.LARGE) {
                canvasItem = new class_1799((class_1935)Items.ITEM_CANVAS_LARGE);
            } else if (this.canvasType == CanvasType.LONG) {
                canvasItem = new class_1799((class_1935)Items.ITEM_CANVAS_LONG);
            } else if (this.canvasType == CanvasType.TALL) {
                canvasItem = new class_1799((class_1935)Items.ITEM_CANVAS_TALL);
            } else {
                Mod.LOGGER.error("Invalid canvas type");
                return;
            }
            class_2487 nbt = new class_2487();
            nbt.method_10582("name", this.canvasName);
            nbt.method_10569("v", this.canvasVersion);
            nbt.method_10569("generation", 0);
            if (this.canvasSigned) {
                nbt.method_10582("author", this.canvasAuthor);
                nbt.method_10582("title", this.canvasTitle);
                nbt.method_10569("generation", this.canvasGeneration);
            }
            if ((picture = PICTURES.get(this.canvasName)) != null) {
                nbt.method_10539("pixels", picture.pixels);
            }
            canvasItem.method_7980(nbt);
            this.method_5775(canvasItem);
        }
    }

    public void method_5773() {
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        if (this.tickCounter1++ == 50 && !this.method_37908().field_9236) {
            this.tickCounter1 = 0;
            if (this.method_5805() && !this.method_6888()) {
                this.method_5650(class_1297.class_5529.field_26999);
                this.method_6889(null);
            }
        }
    }

    public void method_6894() {
        this.method_5783(class_3417.field_14875, 1.0f, 1.0f);
    }

    protected void method_6892(@NotNull class_2350 facingDirectionIn) {
        Validate.notNull((Object)facingDirectionIn);
        this.field_7099 = facingDirectionIn;
        if (facingDirectionIn.method_10166().method_10179()) {
            this.method_36457(0.0f);
            this.method_36456(this.field_7099.method_10161() * 90);
        } else {
            this.method_36457(-90 * facingDirectionIn.method_10171().method_10181());
            this.method_36456(0.0f);
        }
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        this.method_6895();
    }

    private double offs(int l) {
        return l % 32 == 0 ? 0.5 : 0.0;
    }

    protected void method_6895() {
        if (this.canvasType != null) {
            double d1 = (double)this.field_7100.method_10263() + 0.5 - (double)this.field_7099.method_10148() * 0.46875;
            double d2 = (double)this.field_7100.method_10264() + 0.5 - (double)this.field_7099.method_10164() * 0.46875;
            double d3 = (double)this.field_7100.method_10260() + 0.5 - (double)this.field_7099.method_10165() * 0.46875;
            if (this.field_7099.method_10166().method_10179()) {
                double d4 = this.offs(this.method_6897());
                double d5 = this.offs(this.method_6891());
                d2 += d5;
                class_2350 direction = this.field_7099.method_10160();
                d1 += d4 * (double)direction.method_10148();
                d3 += d4 * (double)direction.method_10165();
            }
            this.method_23327(d1, d2, d3);
            double d6 = this.method_6897() - 2;
            double d7 = this.method_6891() - 2;
            double d8 = this.method_6897() - 2;
            class_2350.class_2351 direction$axis = this.field_7099.method_10166();
            switch (direction$axis) {
                case field_11048: {
                    d6 = 1.0;
                    break;
                }
                case field_11052: {
                    d7 = 1.0;
                    break;
                }
                case field_11051: {
                    d8 = 1.0;
                }
            }
            this.method_5857(new class_238(d1 - (d6 /= 32.0), d2 - (d7 /= 32.0), d3 - (d8 /= 32.0), d1 + d6, d2 + d7, d3 + d8));
        }
    }

    public boolean method_6888() {
        if (this.field_7099.method_10166().method_10179()) {
            return super.method_6888();
        }
        if (!this.method_37908().method_17892((class_1297)this)) {
            return false;
        }
        class_2680 blockstate = this.method_37908().method_8320(this.field_7100.method_10093(this.field_7099.method_10153()));
        return (blockstate.method_51367() || this.field_7099.method_10166().method_10179() && class_2312.method_9999((class_2680)blockstate)) && this.method_37908().method_8333((class_1297)this, this.method_5829(), field_7098).isEmpty();
    }

    public int getRotation() {
        return (Integer)this.method_5841().method_12789(ROTATION);
    }

    private void setRotation(int rotation) {
        this.method_5841().method_12778(ROTATION, (Object)(rotation % 4));
    }

    @NotNull
    public class_2596<class_2602> method_18002() {
        ClientboundAddCanvasPacket p = new ClientboundAddCanvasPacket(this);
        class_2540 buf = PacketByteBufs.create();
        p.method_11052(buf);
        return ServerPlayNetworking.createS2CPacket((class_2960)Mod.ADD_CANVAS_PACKET_ID, (class_2540)buf);
    }

    public void method_5749(class_2487 tagCompound) {
        Picture picture;
        this.field_7100 = new class_2338(tagCompound.method_10550("TileX"), tagCompound.method_10550("TileY"), tagCompound.method_10550("TileZ"));
        class_2487 canvasNBT = tagCompound;
        if (tagCompound.method_10545("canvas")) {
            canvasNBT = tagCompound.method_10562("canvas");
        }
        this.canvasSigned = canvasNBT.method_10545("author") && canvasNBT.method_10545("title");
        this.canvasName = canvasNBT.method_10558("name");
        this.canvasVersion = canvasNBT.method_10550("v");
        if (this.canvasSigned) {
            this.canvasAuthor = canvasNBT.method_10558("author");
            this.canvasTitle = canvasNBT.method_10558("title");
            this.canvasGeneration = canvasNBT.method_10550("generation");
        }
        if ((picture = PICTURES.get(this.canvasName)) == null || picture.version < this.canvasVersion) {
            PICTURES.put(this.canvasName, new Picture(this.canvasVersion, canvasNBT.method_10561("pixels")));
        }
        this.canvasType = CanvasType.fromByte(tagCompound.method_10571("ctype"));
        if (tagCompound.method_10545("Facing") && !tagCompound.method_10545("RealFace")) {
            byte facing = tagCompound.method_10571("Facing");
            class_2350 horizontal = class_2350.method_10139((int)facing);
            this.method_6892(horizontal);
        } else {
            this.method_6892(class_2350.method_10143((int)tagCompound.method_10571("RealFace")));
        }
        this.setRotation(tagCompound.method_10571("Rotation"));
    }

    public void method_5652(class_2487 tagCompound) {
        class_2338 blockpos = this.method_6896();
        tagCompound.method_10569("TileX", blockpos.method_10263());
        tagCompound.method_10569("TileY", blockpos.method_10264());
        tagCompound.method_10569("TileZ", blockpos.method_10260());
        tagCompound.method_10582("name", this.canvasName);
        tagCompound.method_10569("v", this.canvasVersion);
        if (this.canvasSigned) {
            tagCompound.method_10582("author", this.canvasAuthor);
            tagCompound.method_10582("title", this.canvasTitle);
            tagCompound.method_10569("generation", this.canvasGeneration);
        }
        tagCompound.method_10567("ctype", (byte)this.canvasType.ordinal());
        tagCompound.method_10567("RealFace", (byte)this.field_7099.method_10146());
        tagCompound.method_10567("Rotation", (byte)this.getRotation());
        Picture picture = PICTURES.get(this.canvasName);
        if (picture != null) {
            tagCompound.method_10539("pixels", picture.pixels);
        }
    }

    private void requestPicture() {
        if (!PICTURE_REQUESTS.contains(this.canvasName)) {
            PICTURE_REQUESTS.add(this.canvasName);
            PictureRequestPacket pack = new PictureRequestPacket(this.canvasName);
            ClientPlayNetworking.send((class_2960)Mod.PICTURE_REQUEST_PACKET_ID, (class_2540)pack.encode());
        }
    }

    public void method_31471(@NotNull class_2604 clientboundAddEntityPacket) {
        super.method_31471(clientboundAddEntityPacket);
        if (clientboundAddEntityPacket instanceof ClientboundAddCanvasPacket) {
            ClientboundAddCanvasPacket cp = (ClientboundAddCanvasPacket)clientboundAddEntityPacket;
            this.canvasName = cp.getCanvasName();
            this.canvasVersion = cp.getCanvasVersion();
            Picture picture = PICTURES.get(this.canvasName);
            if (picture == null || picture.version < this.canvasVersion) {
                this.requestPicture();
            }
            this.field_7099 = class_2350.method_10143((int)cp.getDirectionVal());
            this.canvasType = CanvasType.fromByte(cp.getCanvasTypeVal());
            this.field_7100 = cp.getPos();
            this.setRotation(cp.getRotation());
            this.method_6892(this.field_7099);
        }
    }

    @NotNull
    public class_1269 method_5688(@NotNull class_1657 player, @NotNull class_1268 hand) {
        if (this.canvasType == CanvasType.SMALL || this.canvasType == CanvasType.LARGE) {
            if (!this.method_37908().field_9236) {
                this.setRotation(this.getRotation() + 1);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static class Picture {
        public final int version;
        public final int[] pixels;

        public Picture(int version, int[] pixels) {
            this.version = version;
            this.pixels = pixels;
        }
    }
}

