/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.general;

import dev.emi.trinkets.api.TrinketsApi;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import snownee.jade.addon.general.TargetModifierLoader;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;

@WailaPlugin(value="jadeaddons")
public class GeneralPlugin
implements IWailaPlugin {
    public static final String ID = "jadeaddons";
    public static final class_2960 EQUIPMENT_REQUIREMENT = new class_2960("jadeaddons", "equipment_requirement");
    public static BiPredicate<class_1657, class_6862<class_1792>> EQUIPMENT_CHECK_PREDICATE = (player, tag) -> player.method_6047().method_31573(tag) || player.method_6079().method_31573(tag) || player.method_6118(class_1304.field_6169).method_31573(tag);
    public class_6862<class_1792> requirementTag;

    @Environment(value=EnvType.CLIENT)
    public void registerClient(IWailaClientRegistration registration) {
        registration.addConfig(EQUIPMENT_REQUIREMENT, "", class_2960::method_20207);
        registration.addConfigListener(EQUIPMENT_REQUIREMENT, id -> this.refreshTag((class_2960)id, $ -> {
            this.requirementTag = $;
        }));
        registration.addRayTraceCallback(10000, (hitResult, accessor, originalAccessor) -> {
            if (accessor != null) {
                class_1657 player = accessor.getPlayer();
                if (this.requirementTag != null && !EQUIPMENT_CHECK_PREDICATE.test(player, this.requirementTag)) {
                    return null;
                }
            }
            return accessor;
        });
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            EQUIPMENT_CHECK_PREDICATE = EQUIPMENT_CHECK_PREDICATE.or((player, tag) -> TrinketsApi.getTrinketComponent((class_1309)player).flatMap($ -> Optional.ofNullable($.getInventory())).map($ -> $.getOrDefault("head", Map.of()).values().stream()).map($ -> $.anyMatch($$ -> $$.method_43256(item -> item.method_31573(this.requirementTag)))).orElse(false));
        }
        TargetModifierLoader loader = new TargetModifierLoader();
        CommonLifecycleEvents.TAGS_LOADED.register((registryAccess, client) -> loader.reload());
        registration.addRayTraceCallback((JadeRayTraceCallback)loader);
        registration.addTooltipCollectedCallback((JadeTooltipCollectedCallback)loader);
    }

    private void refreshTag(class_2960 id, Consumer<class_6862<class_1792>> setter) {
        String s = IWailaConfig.get().getPlugin().getString(id);
        if (s.isBlank()) {
            setter.accept(null);
        } else {
            setter.accept((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(s)));
        }
    }
}

