/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks;

import earth.terrarium.handcrafted.common.blocks.base.properties.OptionalColorProperty;
import earth.terrarium.handcrafted.common.blocks.base.properties.TableProperty;
import earth.terrarium.handcrafted.common.constants.ConstantComponents;
import earth.terrarium.handcrafted.common.tags.ModBlockTags;
import earth.terrarium.handcrafted.common.utils.InteractionUtils;
import earth.terrarium.handcrafted.common.utils.TooltipUtils;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<TableProperty> SHAPE = EnumProperty.m_61587_((String)"shape", TableProperty.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<OptionalColorProperty> COLOR = EnumProperty.m_61587_((String)"color", OptionalColorProperty.class);
    public static final VoxelShape SINGLE_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)).reduce(Shapes::m_83110_).get();
    public static final VoxelShape CENTER_SHAPE = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape NORTH_EAST_CORNER_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0));
    public static final VoxelShape NORTH_WEST_CORNER_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0));
    public static final VoxelShape SOUTH_EAST_CORNER_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0));
    public static final VoxelShape SOUTH_WEST_CORNER_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0));
    public static final VoxelShape NORTH_SIDE_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape EAST_SIDE_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SOUTH_SIDE_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape WEST_SIDE_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public TableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)((Object)TableProperty.SINGLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(COLOR, (Comparable)((Object)OptionalColorProperty.NONE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SHAPE, WATERLOGGED, COLOR});
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!level.m_5776_() && state.m_60734_() != newState.m_60734_()) {
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)((OptionalColorProperty)((Object)state.m_61143_(COLOR))).toSheet());
        }
        super.m_6810_(state, level, pos, newState, moved);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionUtils.interactOptionalSheet(state, level, pos, player, hand, COLOR);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((TableProperty)((Object)state.m_61143_(SHAPE))) {
            case TableProperty.SINGLE -> SINGLE_SHAPE;
            case TableProperty.NORTH_EAST_CORNER -> NORTH_EAST_CORNER_SHAPE;
            case TableProperty.NORTH_WEST_CORNER -> NORTH_WEST_CORNER_SHAPE;
            case TableProperty.SOUTH_EAST_CORNER -> SOUTH_EAST_CORNER_SHAPE;
            case TableProperty.SOUTH_WEST_CORNER -> SOUTH_WEST_CORNER_SHAPE;
            case TableProperty.NORTH_SIDE -> NORTH_SIDE_SHAPE;
            case TableProperty.EAST_SIDE -> EAST_SIDE_SHAPE;
            case TableProperty.SOUTH_SIDE -> SOUTH_SIDE_SHAPE;
            case TableProperty.WEST_SIDE -> WEST_SIDE_SHAPE;
            default -> CENTER_SHAPE;
        };
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction.m_122434_().m_122479_() ? (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)this.getShape((BlockGetter)level, currentPos))) : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(pos);
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)this.getShape((BlockGetter)context.m_43725_(), pos)));
    }

    public TableProperty getShape(BlockGetter level, BlockPos pos) {
        boolean northPresent = level.m_8055_(pos.m_121945_(Direction.NORTH)).m_204336_(ModBlockTags.TABLE_CONNECTABLE);
        boolean eastPresent = level.m_8055_(pos.m_121945_(Direction.EAST)).m_204336_(ModBlockTags.TABLE_CONNECTABLE);
        boolean southPresent = level.m_8055_(pos.m_121945_(Direction.SOUTH)).m_204336_(ModBlockTags.TABLE_CONNECTABLE);
        boolean westPresent = level.m_8055_(pos.m_121945_(Direction.WEST)).m_204336_(ModBlockTags.TABLE_CONNECTABLE);
        if (northPresent && eastPresent && southPresent && westPresent) {
            return TableProperty.CENTER;
        }
        if (northPresent && eastPresent && southPresent) {
            return TableProperty.WEST_CENTER;
        }
        if (northPresent && eastPresent && westPresent) {
            return TableProperty.SOUTH_CENTER;
        }
        if (northPresent && southPresent && westPresent) {
            return TableProperty.EAST_CENTER;
        }
        if (eastPresent && southPresent && westPresent) {
            return TableProperty.NORTH_CENTER;
        }
        if (northPresent && southPresent) {
            return TableProperty.EAST_WEST_CENTER;
        }
        if (eastPresent && westPresent) {
            return TableProperty.NORTH_SOUTH_CENTER;
        }
        if (northPresent && eastPresent) {
            return TableProperty.SOUTH_WEST_CORNER;
        }
        if (eastPresent && southPresent) {
            return TableProperty.NORTH_WEST_CORNER;
        }
        if (southPresent && westPresent) {
            return TableProperty.NORTH_EAST_CORNER;
        }
        if (westPresent && northPresent) {
            return TableProperty.SOUTH_EAST_CORNER;
        }
        if (northPresent) {
            return TableProperty.NORTH_SIDE;
        }
        if (eastPresent) {
            return TableProperty.EAST_SIDE;
        }
        if (southPresent) {
            return TableProperty.SOUTH_SIDE;
        }
        if (westPresent) {
            return TableProperty.WEST_SIDE;
        }
        return TableProperty.SINGLE;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        TooltipUtils.addDescriptionComponent(tooltip, ConstantComponents.SHEET);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

