/*
 * Decompiled with CFR 0.152.
 */
package dev.userteemu.ghostfishingfixes;

import dev.userteemu.ghostfishingfixes.FishingRodOwnerPos;
import dev.userteemu.ghostfishingfixes.GhostFishingFixesCompatibilityUtil;
import dev.userteemu.ghostfishingfixes.GhostFishingFixesConfig;
import dev.userteemu.ghostfishingfixes.interfaces.FishingHookOwnerPosInterface;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_634;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GhostFishingFixes
implements ModInitializer,
ClientModInitializer {
    public static final String ID = "ghost_fishing_fixes";
    public static final String NAME = "Ghost Fishing Fixes";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Ghost Fishing Fixes");
    public static final class_2960 FISHING_ROD_OWNER_POS_PACKET = new class_2960("ghost_fishing_fixes", "owner_pos");

    public void onInitialize() {
        GhostFishingFixesCompatibilityUtil.init();
    }

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FISHING_ROD_OWNER_POS_PACKET, this::setRodOwnerPos);
        AutoConfig.register(GhostFishingFixesConfig.class, JanksonConfigSerializer::new);
        GhostFishingFixesConfig.INSTANCE = (GhostFishingFixesConfig)AutoConfig.getConfigHolder(GhostFishingFixesConfig.class).getConfig();
    }

    public static boolean isGhost(class_3222 player) {
        return player instanceof FakePlayer || GhostFishingFixesCompatibilityUtil.PORTING_LIB_FAKE_PLAYER_CLASS != null && GhostFishingFixesCompatibilityUtil.PORTING_LIB_FAKE_PLAYER_CLASS.isInstance(player);
    }

    public void setRodOwnerPos(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        if (client.field_1687 == null) {
            return;
        }
        class_3545<Integer, @Nullable FishingRodOwnerPos> parsed = FishingRodOwnerPos.fromBuf(buf);
        class_1297 entity = client.field_1687.method_8469(((Integer)parsed.method_15442()).intValue());
        if (!(entity instanceof FishingHookOwnerPosInterface)) {
            return;
        }
        ((FishingHookOwnerPosInterface)entity).setOwnerPos((FishingRodOwnerPos)parsed.method_15441());
    }

    public static void updateAndNotifyClients(class_3222 ghost, class_1536 fishingHook, class_3222 ... clients) {
        if (clients.length == 0) {
            return;
        }
        FishingRodOwnerPos ownerPos = ((FishingHookOwnerPosInterface)fishingHook).getOwnerPos();
        if (ownerPos != null && ownerPos.isUpToDate((class_1657)ghost)) {
            return;
        }
        ownerPos = FishingRodOwnerPos.fromPlayer((class_1657)ghost);
        ((FishingHookOwnerPosInterface)fishingHook).setOwnerPos(ownerPos);
        for (class_3222 client : clients) {
            ServerPlayNetworking.send((class_3222)client, (class_2960)FISHING_ROD_OWNER_POS_PACKET, (class_2540)ownerPos.toBuf(fishingHook.method_5628()));
        }
    }

    public static void unloadFromClients(class_1536 fishingHook, class_3222 ... clients) {
        for (class_3222 client : clients) {
            ServerPlayNetworking.send((class_3222)client, (class_2960)FISHING_ROD_OWNER_POS_PACKET, (class_2540)FishingRodOwnerPos.unknownToBuf(fishingHook.method_5628()));
        }
    }
}

