/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item;

import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.hrznstudio.titanium.item.BasicItem;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class StorageUpgradeItem
extends UpgradeItem {
    private final StorageTier storageTier;

    public StorageUpgradeItem(StorageTier tier) {
        super(new Item.Properties(), UpgradeItem.Type.STORAGE);
        this.storageTier = tier;
    }

    public int getStorageMultiplier() {
        return FunctionalStorageConfig.getLevelMult(this.storageTier.getLevel());
    }

    public StorageTier getStorageTier() {
        return this.storageTier;
    }

    @Override
    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        if (this.storageTier == StorageTier.IRON) {
            tooltip.add((Component)Component.m_237115_((String)"item.utility.downgrade").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"storageupgrade.desc.item").m_130940_(ChatFormatting.GRAY).m_130946_(new DecimalFormat().format(FunctionalStorageConfig.getLevelMult(this.storageTier.getLevel()))));
            tooltip.add((Component)Component.m_237115_((String)"storageupgrade.desc.fluid").m_130940_(ChatFormatting.GRAY).m_130946_(new DecimalFormat().format(FunctionalStorageConfig.getLevelMult(this.storageTier.getLevel()) / FunctionalStorageConfig.FLUID_DIVISOR)));
            tooltip.add((Component)Component.m_237110_((String)"storageupgrade.desc.range", (Object[])new Object[]{new DecimalFormat().format(FunctionalStorageConfig.getLevelMult(this.storageTier.getLevel()) / FunctionalStorageConfig.RANGE_DIVISOR)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public boolean m_5812_(ItemStack p_41453_) {
        return this.storageTier == StorageTier.MAX_STORAGE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_7626_(ItemStack p_41458_) {
        Component component = super.m_7626_(p_41458_);
        if (component instanceof MutableComponent) {
            ((MutableComponent)component).m_6270_(Style.f_131099_.m_178520_(this.storageTier == StorageTier.NETHERITE && Minecraft.m_91087_().f_91073_ != null ? Mth.m_14169_((float)((float)(Minecraft.m_91087_().f_91073_.m_46467_() % 360L) / 360.0f), (float)1.0f, (float)1.0f) : this.storageTier.getColor()));
        }
        return component;
    }

    public static enum StorageTier {
        COPPER(1, Mth.m_14159_((float)0.8f, (float)0.42745098f, (float)0.31764707f)),
        GOLD(2, Mth.m_14159_((float)0.9137255f, (float)0.69411767f, (float)0.08235294f)),
        DIAMOND(3, Mth.m_14159_((float)0.1254902f, (float)0.77254903f, (float)0.70980394f)),
        NETHERITE(4, Mth.m_14159_((float)49.0f, (float)41.0f, (float)42.0f)),
        IRON(0, Mth.m_14159_((float)0.50980395f, (float)0.50980395f, (float)0.50980395f)),
        MAX_STORAGE(-1, Mth.m_14159_((float)0.654902f, (float)0.21176471f, (float)0.96862745f));

        private final int level;
        private final int color;

        private StorageTier(int level, int color) {
            this.level = level;
            this.color = color;
        }

        public int getLevel() {
            return this.level;
        }

        public int getColor() {
            return this.color;
        }
    }
}

