/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.forgivingvoid;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingFallEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.forgivingvoid.ForgivingVoidConfig;
import net.blay09.mods.forgivingvoid.ForgivingVoidFallThroughEvent;
import net.blay09.mods.forgivingvoid.mixin.ServerGamePacketListenerImplAccessor;
import net.blay09.mods.forgivingvoid.mixin.ServerPlayerAccessor;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class ForgivingVoid {
    public static final String MOD_ID = "forgivingvoid";

    public static void initialize() {
        ForgivingVoidConfig.initialize();
        Balm.getEvents().onEvent(LivingFallEvent.class, ForgivingVoid::onPlayerFall);
        Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.Start, ForgivingVoid::onPlayerTick);
    }

    public static void onPlayerTick(class_3222 player) {
        int triggerAtY = player.method_37908().method_31607() - ForgivingVoidConfig.getActive().triggerAtDistanceBelow;
        boolean isInVoid = player.method_23318() < (double)triggerAtY && player.field_6036 < (double)triggerAtY;
        boolean isTeleporting = ((ServerGamePacketListenerImplAccessor)player.field_13987).getAwaitingPositionFromClient() != null;
        class_2487 persistentData = Balm.getHooks().getPersistentData((class_1657)player);
        if (ForgivingVoid.isEnabledForDimension((class_5321<class_1937>)player.method_37908().method_27983()) && isInVoid && !isTeleporting && ForgivingVoid.fireForgivingVoidEvent((class_1657)player)) {
            player.method_6092(new class_1293(class_1294.field_5919, 60, 3));
            if (player.method_5782()) {
                player.method_5772();
            }
            player.method_5848();
            ((ServerPlayerAccessor)player).setIsChangingDimension(true);
            player.method_5859(player.method_23317(), (double)ForgivingVoidConfig.getActive().fallingHeight, player.method_23321());
            persistentData.method_10556("ForgivingVoidIsFalling", true);
        } else if (persistentData.method_10577("ForgivingVoidIsFalling")) {
            class_2338 playerPos = player.method_24515();
            if (player.method_5799() || player.method_24828() || player.method_31549().field_7479 || player.method_31549().field_7478 || player.method_37908().method_8320(playerPos).method_26204() == class_2246.field_10343) {
                persistentData.method_10556("ForgivingVoidIsFalling", false);
                ((ServerPlayerAccessor)player).setIsChangingDimension(false);
                return;
            }
            if (ForgivingVoidConfig.getActive().disableVanillaAntiCheatWhileFalling) {
                ((ServerPlayerAccessor)player).setIsChangingDimension(true);
            }
        }
    }

    public static void onPlayerFall(LivingFallEvent event) {
        class_1309 entity = event.getEntity();
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            class_2487 persistentData = Balm.getHooks().getPersistentData((class_1657)player);
            if (persistentData.method_10577("ForgivingVoidIsFalling")) {
                float damage = ForgivingVoidConfig.getActive().damageOnFall;
                if (ForgivingVoidConfig.getActive().preventDeath && player.method_6032() - damage <= 0.0f) {
                    damage = player.method_6032() - 1.0f;
                }
                event.setFallDamageOverride(Float.valueOf(damage));
                ((ServerPlayerAccessor)player).setIsChangingDimension(false);
            }
        }
    }

    private static boolean fireForgivingVoidEvent(class_1657 player) {
        ForgivingVoidFallThroughEvent event = new ForgivingVoidFallThroughEvent(player);
        Balm.getEvents().fireEvent((Object)event);
        return !event.isCanceled();
    }

    private static boolean isEnabledForDimension(class_5321<class_1937> dimensionKey) {
        if (dimensionKey == class_1937.field_25179) {
            return ForgivingVoidConfig.getActive().triggerInOverworld;
        }
        if (dimensionKey == class_1937.field_25181) {
            return ForgivingVoidConfig.getActive().triggerInEnd;
        }
        if (dimensionKey == class_1937.field_25180) {
            return ForgivingVoidConfig.getActive().triggerInNether;
        }
        class_2960 dimension = dimensionKey.method_29177();
        List<String> dimensionAllowList = ForgivingVoidConfig.getActive().dimensionAllowList;
        List<String> dimensionDenyList = ForgivingVoidConfig.getActive().dimensionDenyList;
        if (!dimensionAllowList.isEmpty() && !dimensionAllowList.contains(dimension.toString())) {
            return false;
        }
        return !dimensionDenyList.contains(dimension.toString());
    }
}

