/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.fishermens_trap.integration.jei;

import com.google.common.collect.ImmutableList;
import com.uraneptus.fishermens_trap.FishermensTrap;
import com.uraneptus.fishermens_trap.common.blocks.FishtrapBlockEntity;
import com.uraneptus.fishermens_trap.core.registry.FTItems;
import com.uraneptus.fishermens_trap.integration.jei.FishtrapRecipeWrapper;
import com.uraneptus.fishermens_trap.integration.jei.JEIPlugin;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class FishtrapCategory
implements IRecipeCategory<FishtrapRecipeWrapper> {
    private static final ResourceLocation FISHTRAP_LOCATION = FishermensTrap.modPrefix("textures/gui/jei_fishtrap.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title = Component.m_237115_((String)("fishermens_trap.jei." + this.getUid().m_135815_()));

    public FishtrapCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(FISHTRAP_LOCATION, 0, 0, 162, 51);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)FTItems.FISHTRAP.get()));
    }

    public RecipeType<FishtrapRecipeWrapper> getRecipeType() {
        return JEIPlugin.FISHTRAP_RECIPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FishtrapRecipeWrapper recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 74, 1).addItemStack(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 1, 34).addItemStacks(Arrays.stream(recipe.getOutput().m_43908_()).toList());
    }

    public List<Component> getTooltipStrings(FishtrapRecipeWrapper recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (FishtrapCategory.iconPosition(mouseX, mouseY)) {
            if ((Integer)FishtrapBlockEntity.getMinMaxCounterInts().getSecond() > (Integer)FishtrapBlockEntity.getMinMaxCounterInts().getFirst()) {
                return ImmutableList.of((Object)Component.m_237113_((String)("Items are fished every " + FishtrapBlockEntity.getMinMaxCounterInts().getFirst() + "-" + FishtrapBlockEntity.getMinMaxCounterInts().getSecond() + " ticks")));
            }
            return ImmutableList.of((Object)Component.m_237113_((String)"Error in Config: Min value must be below Max value").m_130940_(ChatFormatting.RED));
        }
        return Collections.emptyList();
    }

    private static boolean iconPosition(double mouseX, double mouseY) {
        int iconPosX = 77;
        int iconPosY = 19;
        int iconHeight = 12;
        int iconWidth = 10;
        return (double)iconPosX <= mouseX && mouseX < (double)(iconPosX + iconWidth) && (double)iconPosY <= mouseY && mouseY < (double)(iconPosY + iconHeight);
    }
}

