/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.retention;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.repo.SnapshotId;
import net.pcal.fastback.retention.RetentionPolicy;
import net.pcal.fastback.retention.RetentionPolicyType;

class DailyRetentionPolicy
implements RetentionPolicy {
    private static final String GRACE_PERIOD_DAYS = "gracePeriodDays";
    private static final int DEFAULT_GRACE_PERIOD_DAYS = 3;
    private static final String L10N_KEY = "fastback.retain.daily.description";
    private final int gracePeriod;

    public DailyRetentionPolicy(int gracePeriod) {
        this.gracePeriod = gracePeriod;
    }

    @Override
    public UserMessage getDescription() {
        return UserMessage.localized(L10N_KEY, this.gracePeriod);
    }

    @Override
    public Collection<SnapshotId> getSnapshotsToPrune(Set<SnapshotId> snapshots) {
        LocalDate today = LocalDate.now(TimeZone.getDefault().toZoneId());
        LocalDate gracePeriodStart = today.minus(Period.ofDays(this.gracePeriod));
        ArrayList<SnapshotId> toPrune = new ArrayList<SnapshotId>();
        LocalDate previousDate = null;
        ArrayList<SnapshotId> sortedDesending = new ArrayList<SnapshotId>(snapshots);
        Collections.sort(sortedDesending, Collections.reverseOrder());
        for (SnapshotId sid : sortedDesending) {
            LocalDate currentDate = sid.getDate().toInstant().atZone(TimeZone.getDefault().toZoneId()).toLocalDate();
            if (previousDate != null) {
                if (currentDate.isAfter(gracePeriodStart)) {
                    SystemLogger.syslog().debug("Will retain " + sid + " because still in the grace period");
                    continue;
                }
                if (currentDate.equals(previousDate)) {
                    SystemLogger.syslog().debug("Will prune " + sid + " same day as " + currentDate);
                    toPrune.add(sid);
                } else {
                    SystemLogger.syslog().debug("Will retain " + sid + " NOT same day as " + currentDate);
                }
            }
            previousDate = currentDate;
        }
        return toPrune;
    }

    public static enum DailyRetentionPolicyType implements RetentionPolicyType
    {
        INSTANCE;


        @Override
        public String getName() {
            return "daily";
        }

        @Override
        public List<RetentionPolicyType.Parameter<?>> getParameters() {
            return List.of(new RetentionPolicyType.Parameter<Integer>(DailyRetentionPolicy.GRACE_PERIOD_DAYS, (ArgumentType<Integer>)IntegerArgumentType.integer((int)0), Integer.class));
        }

        @Override
        public RetentionPolicy createPolicy(Map<String, String> config) {
            int gracePeriodTemp = 3;
            if (config != null && config.containsKey(DailyRetentionPolicy.GRACE_PERIOD_DAYS)) {
                try {
                    gracePeriodTemp = Integer.parseInt(config.get(DailyRetentionPolicy.GRACE_PERIOD_DAYS));
                }
                catch (NumberFormatException nfe) {
                    SystemLogger.syslog().debug("Ignoring invalid grace period " + config.get(DailyRetentionPolicy.GRACE_PERIOD_DAYS), nfe);
                }
            }
            int gracePeriod = gracePeriodTemp;
            return new DailyRetentionPolicy(gracePeriod);
        }

        @Override
        public UserMessage getDescription() {
            return UserMessage.localized(DailyRetentionPolicy.L10N_KEY, "<gracePeriodDays>");
        }
    }
}

