/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.repo;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.pcal.fastback.config.FastbackConfigKey;
import net.pcal.fastback.config.GitConfig;
import net.pcal.fastback.config.OtherConfigKey;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.mod.Mod;
import net.pcal.fastback.repo.JGitIncrementalProgressMonitor;
import net.pcal.fastback.repo.JGitPercentageProgressMonitor;
import net.pcal.fastback.repo.PreflightUtils;
import net.pcal.fastback.repo.RepoImpl;
import net.pcal.fastback.repo.SnapshotId;
import net.pcal.fastback.utils.FileUtils;
import net.pcal.fastback.utils.ProcessException;
import net.pcal.fastback.utils.ProcessUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ProgressMonitor;

abstract class RestoreUtils {
    RestoreUtils() {
    }

    static void doRestoreLocalSnapshot(String snapshotNameToRestore, RepoImpl repo, UserLogger ulog) {
        RestoreUtils.doRestoreSnapshot(snapshotNameToRestore, "file://" + Mod.mod().getWorldDirectory().toAbsolutePath(), repo, ulog);
    }

    static void doRestoreRemoteSnapshot(String snapshotNameToRestore, RepoImpl repo, UserLogger ulog) {
        GitConfig conf = repo.getConfig();
        if (!conf.isSet(OtherConfigKey.REMOTE_PUSH_URL)) {
            ulog.message(UserMessage.styledLocalized("fastback.chat.remote-no-url", UserMessage.UserMessageStyle.ERROR, new Object[0]));
        } else {
            RestoreUtils.doRestoreSnapshot(snapshotNameToRestore, conf.getString(OtherConfigKey.REMOTE_PUSH_URL), repo, ulog);
        }
    }

    private static void doRestoreSnapshot(String snapshotNameToRestore, String repoUri, RepoImpl repo, UserLogger ulog) {
        try {
            PreflightUtils.doPreflight(repo);
            GitConfig conf = repo.getConfig();
            SnapshotId sid = repo.createSnapshotId(snapshotNameToRestore);
            Path allRestoresDir = conf.isSet(FastbackConfigKey.RESTORE_DIRECTORY) ? Paths.get(conf.getString(FastbackConfigKey.RESTORE_DIRECTORY), new String[0]) : Mod.mod().getDefaultRestoresDir();
            Path restoreTargetDir = RestoreUtils.getTargetDir(allRestoresDir, Mod.mod().getWorldName(), sid.getShortName());
            if (conf.getBoolean(FastbackConfigKey.IS_NATIVE_GIT_ENABLED)) {
                RestoreUtils.native_restoreSnapshot(sid.getBranchName(), restoreTargetDir, repoUri, ulog);
            } else {
                RestoreUtils.jgit_restoreSnapshot(sid.getBranchName(), restoreTargetDir, repoUri, ulog);
            }
            ulog.message(UserMessage.localized("fastback.chat.restore-done", restoreTargetDir));
        }
        catch (Exception e) {
            SystemLogger.syslog().error(e);
            ulog.message(UserMessage.styledRaw("Restore failed.  See log for details.", UserMessage.UserMessageStyle.ERROR));
        }
    }

    private static void native_restoreSnapshot(String branchName, Path restoreTargetDir, String repoUri, UserLogger ulog) throws ProcessException {
        Map<String, String> env = Map.of("GIT_LFS_FORCE_PROGRESS", "1");
        Consumer<String> outputConsumer = line -> ulog.update(UserMessage.styledRaw(line, UserMessage.UserMessageStyle.NATIVE_GIT));
        String restoreTargetDirStr = restoreTargetDir.toString();
        SystemLogger.syslog().debug("Cloning repo at " + repoUri);
        ProcessUtils.doExec(new String[]{"git", "clone", repoUri, "--no-checkout", "--branch", branchName, "--single-branch", restoreTargetDirStr}, env, outputConsumer, outputConsumer);
        SystemLogger.syslog().debug("Installing lfs locally in " + restoreTargetDirStr);
        ProcessUtils.doExec(new String[]{"git", "-C", restoreTargetDirStr, "lfs", "install", "--local"}, env, outputConsumer, outputConsumer);
        SystemLogger.syslog().debug("Checking out " + branchName + ", downloading lfs blobs");
        ProcessUtils.doExec(new String[]{"git", "-C", restoreTargetDirStr, "checkout", branchName}, env, outputConsumer, outputConsumer);
    }

    private static void jgit_restoreSnapshot(String branchName, Path restoreTargetDir, String repoUri, UserLogger ulog) throws IOException, GitAPIException {
        ulog.update(UserMessage.localized("fastback.hud.restore-percent", 0));
        JGitIncrementalProgressMonitor pm = new JGitIncrementalProgressMonitor(new JGitRestoreProgressMonitor(ulog), 100);
        Git git = Git.cloneRepository().setProgressMonitor((ProgressMonitor)pm).setDirectory(restoreTargetDir.toFile()).setBranchesToClone(List.of("refs/heads/" + branchName)).setBranch(branchName).setURI(repoUri).call();
        if (git != null) {
            git.close();
        }
        FileUtils.rmdir(restoreTargetDir.resolve(".git"));
    }

    private static Path getTargetDir(Path allRestoresDir, String worldName, String snapshotName) {
        Path base;
        worldName = worldName.replaceAll("\\W+", "");
        Path candidate = base = allRestoresDir.resolve(worldName + "-" + snapshotName);
        int i = 0;
        while (candidate.toFile().exists()) {
            candidate = Path.of(base + "_" + ++i, new String[0]);
            if (i <= 1000) continue;
            throw new IllegalStateException("wat i = " + i);
        }
        return candidate;
    }

    private static class JGitRestoreProgressMonitor
    extends JGitPercentageProgressMonitor {
        private final UserLogger ulog;

        public JGitRestoreProgressMonitor(UserLogger ulog) {
            this.ulog = Objects.requireNonNull(ulog);
        }

        @Override
        public void progressStart(String task) {
        }

        @Override
        public void progressUpdate(String task, int percentage) {
            String message = task + " " + percentage + "%";
            SystemLogger.syslog().debug(message);
            this.ulog.update(UserMessage.styledRaw(message, UserMessage.UserMessageStyle.JGIT));
        }

        @Override
        public void progressDone(String task) {
        }

        public void showDuration(boolean enabled) {
        }
    }
}

