/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.repo;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.pcal.fastback.config.FastbackConfigKey;
import net.pcal.fastback.config.GitConfig;
import net.pcal.fastback.config.GitConfigKey;
import net.pcal.fastback.config.OtherConfigKey;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.repo.Repo;
import net.pcal.fastback.repo.RepoFactory;
import net.pcal.fastback.repo.RepoImpl;
import net.pcal.fastback.repo.WorldIdUtils;
import net.pcal.fastback.utils.EnvironmentUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;

class RepoFactoryImpl
implements RepoFactory {
    RepoFactoryImpl() {
    }

    @Override
    public void doInit(Path worldSaveDir, UserLogger ulog) throws IOException {
        if (this.isGitRepo(worldSaveDir)) {
            WorldIdUtils.ensureWorldHasId(worldSaveDir);
            ulog.message(UserMessage.styledRaw("Backups already initialized.", UserMessage.UserMessageStyle.WARNING));
            return;
        }
        try (Git jgit = Git.init().setDirectory(worldSaveDir.toFile()).call();){
            WorldIdUtils.createWorldId(worldSaveDir);
            RepoImpl repo = new RepoImpl(jgit);
            GitConfig.Updater updater = repo.getConfig().updater();
            updater.set((GitConfigKey)OtherConfigKey.COMMIT_SIGNING_ENABLED, false);
            if (EnvironmentUtils.isNativeGitInstalled()) {
                ulog.message(UserMessage.styledRaw("Native git detected.", UserMessage.UserMessageStyle.NATIVE_GIT));
                updater.set((GitConfigKey)FastbackConfigKey.IS_NATIVE_GIT_ENABLED, true);
            } else {
                ulog.message(UserMessage.styledRaw("Native git not installed on your system.", UserMessage.UserMessageStyle.WARNING));
                ulog.message(UserMessage.raw("Native git is not required but it makes Fastback *much* faster.  You are strongly encouraged to install it *before* doing your first backup."));
                ulog.message(UserMessage.raw("For more information, see https://pcal43.github.io/fastback/native-git.html"));
                updater.set((GitConfigKey)FastbackConfigKey.IS_NATIVE_GIT_ENABLED, false);
            }
            updater.save();
            ulog.message(UserMessage.raw("Backups initialized.  Run '/backup local' to do your first backup.  '/backup help' for more options."));
        }
        catch (GitAPIException e) {
            SystemLogger.syslog().error("Error initializing repo", e);
            throw new IOException(e);
        }
    }

    @Override
    public boolean doInitCheck(Path worldSaveDir, UserLogger ulog) {
        if (!this.isGitRepo(worldSaveDir)) {
            ulog.message(UserMessage.styledRaw("Please run '/backup init' first.", UserMessage.UserMessageStyle.ERROR));
            return false;
        }
        return true;
    }

    @Override
    public Repo load(Path worldSaveDir) throws IOException {
        Git jgit = Git.open((File)worldSaveDir.toFile());
        WorldIdUtils.ensureWorldHasId(worldSaveDir);
        return new RepoImpl(jgit);
    }

    @Override
    public boolean isGitRepo(Path worldSaveDir) {
        File dotGit = worldSaveDir.resolve(".git").toFile();
        return dotGit.exists() && dotGit.isDirectory();
    }
}

